% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{opts_selection}
\alias{opts_selection}
\alias{opts_selection_key}
\alias{opts_selection_theme}
\title{Selection effect settings}
\usage{
opts_selection(
  css = NULL,
  type = "multiple",
  only_shiny = TRUE,
  selected = character(0)
)

opts_selection_key(
  css = NULL,
  type = "single",
  only_shiny = TRUE,
  selected = character(0)
)

opts_selection_theme(
  css = NULL,
  type = "single",
  only_shiny = TRUE,
  selected = character(0)
)
}
\arguments{
\item{css}{css to associate with elements when they are selected.
It must be a scalar character. It can also be constructed with
\code{\link{girafe_css}}, to give more control over the css for different element types.}

\item{type}{selection mode ("single", "multiple", "none")
when widget is in a Shiny application.}

\item{only_shiny}{disable selections if not in a shiny context.}

\item{selected}{character vector, id to be selected when the graph will be
initialized.}
}
\description{
Allows customization of the rendering of
selected graphic elements.
Use \code{opts_selection} for interactive geometries in panels,
\code{opts_selection_key} for interactive scales/guides and
\code{opts_selection_theme} for interactive theme elements.
}
\examples{
library(ggplot2)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg <- ggplot(
  data = dataset,
  mapping = aes(x = wt, y = qsec, color = disp,
                tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg)
x <- girafe_options(x,
  opts_selection(type = "multiple",
    css = "fill:red;stroke:gray;r:5pt;") )
if( interactive() ) print(x)
}
\seealso{
Other girafe animation options: 
\code{\link{girafe_options}()},
\code{\link{opts_hover}()},
\code{\link{opts_sizing}()},
\code{\link{opts_toolbar}()},
\code{\link{opts_tooltip}()},
\code{\link{opts_zoom}()}
}
\concept{girafe animation options}
