% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{opts_tooltip}
\alias{opts_tooltip}
\title{Tooltip settings}
\usage{
opts_tooltip(css = NULL, offx = 10, offy = 0,
  use_cursor_pos = TRUE, opacity = 0.9, use_fill = FALSE,
  use_stroke = FALSE, delay_mouseover = 200, delay_mouseout = 500,
  zindex = 999)
}
\arguments{
\item{css}{extra css (added to \code{position: absolute;pointer-events: none;})
used to customize tooltip area.}

\item{offx, offy}{tooltip x and y offset}

\item{use_cursor_pos}{should the cursor position be used to
position tooltip (in addition to offx and offy). Setting to
TRUE will have no effect in the RStudio browser windows.}

\item{opacity}{tooltip background opacity}

\item{use_fill, use_stroke}{logical, use fill and stroke properties to
color tooltip.}

\item{delay_mouseover}{The duration in milliseconds of the
transition associated with tooltip display.}

\item{delay_mouseout}{The duration in milliseconds of the
transition associated with tooltip end of display.}

\item{zindex}{tooltip css z-index, default to 999.}
}
\description{
Settings to be used with \code{\link{girafe}}
for tooltip customisation.
}
\examples{
library(ggplot2)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg <- ggplot(
  data = dataset,
  mapping = aes(x = wt, y = qsec, color = disp,
                tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg)
x <- girafe_options(x,
  opts_tooltip(opacity = .7,
    offx = 20, offy = -10,
    use_fill = TRUE, use_stroke = TRUE,
    delay_mouseout = 1000) )
if( interactive() ) print(x)
}
\seealso{
Other girafe animation options: \code{\link{girafe_options}},
  \code{\link{opts_hover}}, \code{\link{opts_selection}},
  \code{\link{opts_sizing}}, \code{\link{opts_toolbar}},
  \code{\link{opts_zoom}}
}
\concept{girafe animation options}
