% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcortest.R
\name{ggcortest}
\alias{ggcortest}
\title{Plot test for association between paired samples}
\usage{
ggcortest(t, colaccept="lightskyblue1", colreject="grey94", colstat="navy")
}
\arguments{
\item{t}{a list result of \code{\link{cor.test}} of "htest" class}

\item{colaccept}{color the acceptance area of the test}

\item{colreject}{color for the rejection area of the test}

\item{colstat}{color for the test statistic vline}
}
\description{
Visualise test for association between paired samples, 
using Pearson's product moment correlation coefficient.
}
\examples{

corr_test <- cor.test(iris$Sepal.Length, iris$Sepal.Width)
corr_test
ggcortest(corr_test)

}
