% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_text_aimed.R
\name{geom_text_aimed}
\alias{geom_text_aimed}
\title{Aimed text}
\usage{
geom_text_aimed(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  flip_upsidedown = TRUE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointy specified with
\code{nudge_x} or \code{nudge_y}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{flip_upsidedown}{A \code{logical(1)}. If \code{TRUE} (default), the
angle of text placed at angles between 90 and 270 degrees is flipped so
that it is more comfortable to read. If \code{FALSE}, will take calculated
angles literally.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggplot2 \code{Layer}
}
\description{
Similar to \code{geom_text()}, this geom also generates text but places the
text at an angle so that the text seems aimed towards a point defined by
\code{[xend, yend]}.
}
\details{
The calculated angle is such that the text will be parallel to a
  line passing through the coordinates \code{[x, y]} and \code{[xend, yend]}.
  The calculated angle is added to the \code{angle} angle aesthetic, so that
  you can set text perpendicular to that line by setting \code{angle = 90}.
  These angles are calculated in absolute coordinates, meaning that resizing
  the plot will retain the same appearance.
}
\note{
When using this geom to aim text at the centre of a polar plot, make
  sure the radius range does not have close to zero width.
}
\section{Aesthetics}{

\code{geom_text_aimed()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \strong{\code{label}}
  \item \code{alpha}
  \item \code{angle}
  \item \code{colour}
  \item \code{family}
  \item \code{fontface}
  \item \code{group}
  \item \code{hjust}
  \item \code{lineheight}
  \item \code{size}
  \item \code{vjust}
  \item \code{xend}
  \item \code{yend}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
# Point all labels to upper right corner
ggplot(mtcars, aes(mpg, wt)) +
  geom_text_aimed(aes(label = rownames(mtcars)),
                  xend = Inf, yend = Inf)

# Point all labels to center of polar plot
ggplot(mpg, aes(manufacturer)) +
  geom_bar(width = 1, aes(fill = manufacturer), show.legend = FALSE) +
  geom_text_aimed(aes(label = manufacturer), hjust = 0,
                  stat = "count", nudge_y = 2) +
  scale_x_discrete(labels = NULL) +
  coord_polar()
}
