% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{swap_if}
\alias{swap_if}
\title{Swap values of two columns based on a condition}
\usage{
swap_if(x, condition, ...)
}
\arguments{
\item{x}{a tibble}

\item{condition}{an expression to be evaluated in data context returning a
TRUE/FALSE vector}

\item{...}{the two columns bewteen which values are to be swapped in
dplyr::select-like syntax}
}
\value{
a tibble with conditionally swapped start and end
}
\description{
Swap values of two columns based on a condition
}
\examples{
x <- tibble::tibble(start = c(10, 100), end = c(30, 50))
# ensure start of a range is always smaller than the end
swap_if(x, start > end, start, end)
}
