% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_fitdistr}
\alias{gf_fitdistr}
\title{Plot density function based on fit to data}
\usage{
gf_fitdistr(object = NULL, gformula = NULL, data = NULL, geom = "path",
  stat = "fitdistr", position = "identity", show.legend = NA,
  show.help = NULL, inherit = FALSE, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument. See examples.}

\item{gformula}{A formula with shape \code{~ x} used to specify the data
to be fit to a family of distributions.}

\item{data}{A data frame containing the variable to be fitted.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{...}{Additional arguments}
}
\value{
a gg object
}
\description{
\code{MASS::fitdistr()} is used to fit coeffecients of a specified family of
distributions and the resulting density curve is displayed.
}
\examples{
if (require(mosaicData)) {
  gf_fitdistr( ~ length, data = KidsFeet, inherit = FALSE) \%>\%
    gf_dhistogram( ~ length, data = KidsFeet, binwidth = 0.5, alpha = 0.25)

  gf_dhistogram( ~ length, data = KidsFeet, binwidth = 0.5, alpha = 0.25) \%>\%
    gf_fitdistr()
}
}
\seealso{
\code{\link[mosaicCore:fit_distr_fun]{mosaicCore::fit_distr_fun()}}
}
