% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_function2d.R
\name{gf_function_2d}
\alias{gf_function_2d}
\alias{gf_function2d}
\alias{gf_function_contour}
\alias{gf_function_tile}
\alias{gf_fun_2d}
\alias{gf_fun2d}
\alias{gf_fun_tile}
\alias{gf_fun_contour}
\title{Plot functions of two variables}
\usage{
gf_function_2d(
  object = NULL,
  fun = identity,
  xlim = NULL,
  ylim = NULL,
  ...,
  tile = TRUE,
  contour = TRUE,
  resolution = 50
)

gf_function2d(
  object = NULL,
  fun = identity,
  xlim = NULL,
  ylim = NULL,
  ...,
  tile = TRUE,
  contour = TRUE,
  resolution = 50
)

gf_function_contour(
  object = NULL,
  fun = identity,
  xlim = NULL,
  ylim = NULL,
  ...,
  resolution = 50
)

gf_function_tile(
  object = NULL,
  fun = identity,
  xlim = NULL,
  ylim = NULL,
  ...,
  resolution = 50
)

gf_fun_2d(
  object = NULL,
  formula = NULL,
  xlim = NULL,
  ylim = NULL,
  tile = TRUE,
  contour = TRUE,
  ...,
  resolution = 50
)

gf_fun2d(
  object = NULL,
  formula = NULL,
  xlim = NULL,
  ylim = NULL,
  tile = TRUE,
  contour = TRUE,
  ...,
  resolution = 50
)

gf_fun_tile(
  object = NULL,
  formula = NULL,
  xlim = NULL,
  ylim = NULL,
  ...,
  resolution = 50
)

gf_fun_contour(
  object = NULL,
  formula = NULL,
  xlim = NULL,
  ylim = NULL,
  ...,
  resolution = 50
)
}
\arguments{
\item{object}{An R object, typically of class "gg".}

\item{fun}{A function of two variables to be plotted.}

\item{xlim}{x limits for generating points to be plotted.}

\item{ylim}{y limits for generating points to be plotted.}

\item{...}{additional arguments passed to \code{\link[=gf_tile]{gf_tile()}} or \code{\link[=gf_contour]{gf_contour()}}.}

\item{tile}{A logical indicating whether the tile layer should be drawn.}

\item{contour}{A logical indicating whether the contour layer should be drawn.}

\item{resolution}{A numeric vector of length 1 or 2 specifying the
number of grid points at which the function is evaluated (in each dimension).}

\item{formula}{A formula describing a function of two variables to be plotted.  See \code{\link[mosaic:reexports]{mosaic::makeFun()}}
for details regarding the conversion from a formula to a function.}
}
\value{
A gg plot.
}
\description{
Plot functions of two variables as tile and/or contour plots.
}
\examples{
theme_set(theme_bw())
gf_function_2d(fun = function(x, y) sin(2 * x * y), xlim = c(-pi, pi), ylim = c(-pi, pi)) |>
  gf_refine(scale_fill_viridis_c())
gf_function_2d(fun = function(x, y) x + y, contour = FALSE)
gf_function_tile(fun = function(x, y) x * y) |>
  gf_function_contour(fun = function(x, y) x * y, color = "white") |>
  gf_refine(scale_fill_viridis_c())
gf_fun_tile(x * y ~ x + y, xlim = c(-3, 3), ylim = c(-2, 2)) |>
  gf_fun_contour(x * y ~ x + y, color = "white") |>
  gf_refine(scale_fill_viridis_c()) |>
  gf_labs(fill = "product")
}
