% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{discrete_breaks}
\alias{discrete_breaks}
\title{Discrete Breaks}
\usage{
discrete_breaks(resolution = 1)
}
\arguments{
\item{resolution}{Resolution of the breaks}
}
\value{
A function that can be passed to scales functions as the \code{breaks} argument.
}
\description{
Creates a function that can be passed to scales for creating discrete breaks
at multilples of \code{resolution}.
}
\examples{
x <- rbinom(100, 100, 0.4)
p <- gf_bar( ~ x)
p \%>\% gf_refine(scale_x_continuous(breaks = discrete_breaks()))
p \%>\% gf_refine(scale_x_continuous(breaks = discrete_breaks(5)))
p \%>\% gf_refine(scale_x_continuous(breaks = discrete_breaks(2)))
}
