% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc_bar.R
\name{geom_arc_bar}
\alias{geom_arc_bar}
\alias{stat_arc_bar}
\alias{stat_pie}
\title{Arcs and wedges as polygons}
\usage{
stat_arc_bar(mapping = NULL, data = NULL, geom = "arc_bar",
  position = "identity", n = 360, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

stat_pie(mapping = NULL, data = NULL, geom = "arc_bar",
  position = "identity", n = 360, sep = 0, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)

geom_arc_bar(mapping = NULL, data = NULL, stat = "arc_bar",
  position = "identity", n = 360, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}
or \code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE}
(the default), is combined with the default mapping at the top level of the
plot. You only need to supply mapping if there isn't a mapping defined for
the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{geom, }{stat Override the default connection between \code{geom_arc_bar}
and \code{stat_arc_bar}.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{n}{The number of points used to draw a full circle. The number of
points on each arc will then be calculated as n / span-of-arc}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. borders.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
are three types of arguments you can use here:
\itemize{
 \item{Aesthetics: to set an aesthetic to a fixed value, like
 \code{color = "red"} or \code{size = 3.}}
 \item{Other arguments to the layer, for example you override the default
 \code{stat} associated with the layer.}
 \item{Other arguments passed on to the stat.}
}}

\item{sep}{The separation between arcs in pie/donut charts}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}
}
\description{
This set of stats and geoms makes it possible to draw arcs and wedges as
known from pie and donut charts as well as more specialized plottypes such as
sunburst plots.
}
\details{
An arc bar is the thick version of an arc; that is, a circle segment
drawn as a polygon in the same way as a rectangle is a thick version of a
line. A wedge is a special case of an arc where the inner radius is 0. As
opposed to applying coord_polar to a stacked bar chart, these layers are
drawn in cartesian space, which allows for transformations not possible with
the native ggplot2 approach. Most notable of these are the option to explode
arcs and wedgets away from their center point, thus detaching it from the
main pie/donut.
}
\section{Aesthetics}{

geom_arc_bar understand the following aesthetics (required aesthetics are in
bold):
\itemize{
 \item{\strong{x0}}
 \item{\strong{y0}}
 \item{\strong{r0}}
 \item{\strong{r}}
 \item{\strong{start} - when using stat_arc_bar}
 \item{\strong{end} - when using stat_arc_bar}
 \item{\strong{amount} - when using stat_pie}
 \item{explode}
 \item{color}
 \item{fill}
 \item{size}
 \item{linetype}
 \item{alpha}
}
}

\section{Computed variables}{

\describe{
 \item{x, y}{x and y coordinates for the polygon}
}

\describe{
 \item{x, y}{The start coordinates for the segment}
}
}
\examples{
# If you know the angle spans to plot it is easy
arcs <- data.frame(
  start = seq(0, 2*pi, length.out=11)[-11],
  end = seq(0, 2*pi, length.out=11)[-1],
  r = rep(1:2, 5)
)

# Behold the arcs
ggplot() + geom_arc_bar(aes(x0=0, y0=0, r0=r-1, r=r, start=start, end=end,
                        fill = r),
                    data=arcs)

# If you got values for a pie chart, use stat_pie
states <- c('eaten', "eaten but said you didn't", 'cat took it', 'for tonight',
            'will decompose slowly')
pie <- data.frame(
  state = factor(rep(states, 2), levels = states),
  type = rep(c('Pie', 'Donut'), each = 5),
  r0 = rep(c(0, 0.8), each = 5),
  focus=rep(c(0.2, 0, 0, 0, 0), 2),
  amount = c(4,3, 1, 1.5, 6, 6, 1, 2, 3, 2),
  stringsAsFactors = FALSE
)

# Look at the cakes
ggplot() + geom_arc_bar(aes(x0=0, y0=0, r0=r0, r=1, amount=amount,
                            fill=state, explode=focus),
                        data=pie, stat='pie') +
  facet_wrap(~type, ncol=1) +
  coord_fixed() +
  theme_no_axes() +
  scale_fill_brewer('', type='qual')

}
\author{
Thomas Lin Pedersen
}
\seealso{
\code{\link{geom_arc}} for drawing arcs as lines
}

