% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_model.R
\name{model.dmc}
\alias{model.dmc}
\title{Creating a Model Object}
\usage{
model.dmc(p.map, factors = list(S = c("s1", "s2")), responses = c("r1",
  "r2"), match.map = list(M = list(s1 = 1, s2 = 2)), constants = numeric(0),
  type = "norm", posdrift = TRUE, verbose = TRUE)
}
\arguments{
\item{p.map}{list factors and constants for parameters}

\item{factors}{Factor names and levels}

\item{responses}{Response (accumulator) names}

\item{match.map}{Scores responses}

\item{constants}{Parameters set to constant value}

\item{type}{model type. Should go to class in the future}

\item{posdrift}{only used by norm (ie LBA model)}

\item{verbose}{Print p.vector, constants and type}
}
\description{
\code{model.dmc} Creates an array object ("model") with a set of attributes
specifying a particular model and parameterisation. Call \pkg{coda} to
summarise the model parameters in a DMC samples with multiple participants
at the hyper level.
}
\details{
\code{model.dmc} creates a matrix used by \code{get.par.mat} to arrange
elements of a parameter vector appropriately. The attributes of output used by
\code{get.par.mat} to add in constants and check \code{transform.par}
creates the right parameters.
}
\examples{
m1 <- model.dmc(
   p.map     = list(a="1",v="F",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
   match.map = list(M=list(s1="r1",s2="r2")),
   factors=list(S=c("s1","s2"), F=c("f1","f2")),
   constants = c(st0=0,d=0),
   responses = c("r1","r2"),
   type = "rd")
}
\keyword{model.dmc}

