% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getAccumulatorMatrix}
\alias{getAccumulatorMatrix}
\title{Map a parameter vector to an accumulator matrix}
\usage{
getAccumulatorMatrix(pVec, cell, model, n1order = TRUE)
}
\arguments{
\item{pVec}{a user supplied parameter vector or a sampler supplied theta/phi
vector.}

\item{cell}{a string indicating the name of a experimental condition}

\item{model}{an EAM model specification, created usually by model.dmc. Read
as a NumericVector, so attributes are kept.}

\item{n1order}{a boolean value indicating if swap accumulator row to use
"n1" order. This is for LBA model}
}
\value{
an accumulator x EAM parameter matrix (without factor level).
}
\description{
An Rcpp function to get accumulator x parameter matrix for a design cell. For
two accumulator model, like drift-diffusion model, the accumulators are r1
and r2. For mulitple-accumulator model, like LBA model, the accumulators
are r1, r2, r3, etc. But because LBA probability density has yet
implemented, the function now only works for DDM. The part calling
\code{transform.dmc} is replaced by ordering the parameter sequence inside
\code{density.cpp}. The \code{n1order} switch is still kept, until the R's
\code{simulate.dmc} is upgraded to C++ version. This function is akin to
DMC's \code{p.df.dmc}. This is a Rcpp function.
}
\examples{
m1 <- model.dmc(
    p.map     = list(a="1",v="F",z="1",d="1",sz="1",sv="F",t0="1",st0="1"),
    match.map = list(M=list(s1="r1", s2="r2")),
    factors   = list(S=c("s1","s2"), F=c("f1","f2")),
    constants = c(st0=0,d=0),
    responses = c("r1","r2"),
    type      = "rd")
# Parameter vector names are: ( see attr(,"p.vector") )
# [1] "a"     "v.f1"  "v.f2"  "z"     "sz"    "sv.f1" "sv.f2" "t0"
#
# Constants are (see attr(,"constants") ):
#   st0   d
#     0   0
#
# Model type = rd

attr(m1,"p.vector")
# a  v.f1  v.f2     z    sz sv.f1 sv.f2    t0
# NA    NA    NA    NA    NA    NA    NA    NA
pVec <- c(1,1,1,1, 1,1,1,1)
names(pVec) <- names(attr(m1, "p.vector"))

accMat1 <- getAccumulatorMatrix(pVec, "s1.f1.r2", m1, FALSE)
##         col_names
##row_names a v z d sz sv t0 st0
##       r1 1 1 0 0  1  1  1   0
##       r2 1 1 0 0  1  1  1   0
accMat2 <- getAccumulatorMatrix(pVec, "s1.f1.r2", m1, TRUE)
}

