% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{add_annotation}
\alias{add_annotation}
\title{Add annotations to ggplot heatmap}
\usage{
add_annotation(
  plt,
  context = c("rows", "cols"),
  annot_df,
  annot_pos,
  annot_size,
  annot_border_lwd = 0.5,
  annot_border_col = "grey",
  annot_border_lty = 1,
  show_annot_names = TRUE,
  na_remove = FALSE,
  col_scale = NULL,
  names_side,
  name_params = NULL
)
}
\arguments{
\item{plt}{\code{ggplot} object with \code{geom_tile} layer to add annotations to.}

\item{context}{Dimension to add annotations to, either "rows" or "columns".}

\item{annot_df}{Data frame containing the annotations.
The first column must contain the labels used in the heatmap rows or columns.
Each of the other columns should contain corresponding annotations. The column names are used as labels in the legend.}

\item{annot_pos}{Positions of annotations. x positions if row annotations, y positions if column annotations.
Positions are given by the middle coordinate of the annotation cells.}

\item{annot_size}{Size of annotations, width of row annotations, height if column annotations.}

\item{annot_border_lwd}{Linewidth of border lines of annotation cells.}

\item{annot_border_col}{Colour of border lines of annotation cells.}

\item{annot_border_lty}{Linetype of border lines of annotation cells.}

\item{show_annot_names}{Logical indicating if the annotation names should be drawn.}

\item{na_remove}{Logical indicating if NA values should be removed.}

\item{col_scale}{Named list of fill scales to use, named after the columns in the annotation data frame.
Each element should either be a \verb{scale_fill_*} object or a string specifying a brewer palette or viridis option.}

\item{names_side}{String specifying which side the labels should be drawn on. "top" or "bottom" for row annotation, "left" or "right" for column annotation.}

\item{name_params}{A named list of parameters to give \code{grid::textGrob} to modify annotation label appearance.}
}
\value{
\code{ggplot} object with added annotations.
}
\description{
Add annotations to ggplot heatmap
}
\keyword{internal}
