% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-layer-list.R, R/layer-list.R
\docType{class}
\name{layer_list}
\alias{layer_list}
\alias{layer_list-class}
\alias{as_layer_list}
\alias{as_layer_list.layer_list}
\alias{as_layer_list.list}
\alias{as_layer_list.LayerInstance}
\alias{+,layer_list,layer_list-method}
\alias{show,layer_list-method}
\title{Lists of layer-like objects}
\usage{
layer_list(...)

as_layer_list(x)

\method{as_layer_list}{layer_list}(x)

\method{as_layer_list}{list}(x)

\method{as_layer_list}{LayerInstance}(x)

\S4method{+}{layer_list,layer_list}(e1, e2)

\S4method{show}{layer_list}(object)
}
\arguments{
\item{x, ...}{\link{layer-like} objects}

\item{object, e1, e2}{\code{\link[=layer_list]{layer_list()}}s}
}
\value{
An object of class \code{"layer_list"}.
}
\description{
A list of \link{layer-like} objects, which can be used in layer \link{operation}s
(through function application or multiplication) or added to a \code{\link[=ggplot2]{ggplot2()}}
object.
}
\details{
For the most part, users of \pkg{ggblend} need not worry about this class.
It is used internally to simplify multiple dispatch on binary operators, as
the alternative (\code{\link[=list]{list()}}s of \code{\link[ggplot2:layer]{ggplot2::layer()}}s) is more cumbersome.
\pkg{ggblend} converts input lists to this format as needed.
}
\examples{
library(ggplot2)

# layer_list()s act just like list()s of layer()s in that they can
# be added to ggplot() objects
data.frame(x = 1:10) |>
  ggplot(aes(x, x)) +
  layer_list(
    geom_line(),
    geom_point()
  )

}
