% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-stack-switch.R
\name{stack_switch}
\alias{stack_switch}
\alias{stack_active}
\title{Determine the active context of stack layout}
\usage{
stack_switch(sizes = NULL, what = waiver())

stack_active(
  sizes = NULL,
  what = NULL,
  ...,
  guides = deprecated(),
  free_spaces = deprecated(),
  plot_data = deprecated(),
  theme = deprecated(),
  free_labs = deprecated()
)
}
\arguments{
\item{sizes}{A numeric or a \code{\link[grid:unit]{unit}} object of length \code{3}
indicating the relative heights (for \code{direction = "horizontal"}) or widths
(for \code{direction = "vertical"}).}

\item{what}{What should get activated for the stack layout?
A single number or string of the plot elements in the stack layout. If \code{NULL}, will remove any active context, this is useful when the active context is a
\code{\link[=quad_layout]{quad_layout()}} object, where any \verb{align_*()} will be added to the
\code{\link[=quad_layout]{quad_layout()}}. By removing the active context, we can add \verb{align_*()}
into the \code{\link[=stack_layout]{stack_layout()}}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{guides}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}

\item{free_spaces}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}

\item{plot_data}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_data]{plot_data()}} function instead.}

\item{theme}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_theme]{plot_theme()}} function instead.}

\item{free_labs}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}
}
\value{
A \code{stack_switch} object which can be added to \code{\link[=stack_layout]{stack_layout()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{stack_active} is an alias for \code{stack_switch()}, which sets \code{what = NULL} by
default, with additional arguments for backward compatibility.
}
\examples{
stack_align(matrix(1:9, nrow = 3L), "h") +
    ggheatmap() +
    # ggheamtap will set the active context, directing following addition
    # into the heatmap plot area. To remove the heatmap active context,
    # we can use `stack_active()` which will direct subsequent addition into
    # the stack
    stack_active() +
    # here we add a dendrogram to the stack.
    align_dendro()
}
