% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_horizon.R
\name{ggplot_horizon}
\alias{ggplot_horizon}
\title{Plot a time series as a horizon plot}
\usage{
ggplot_horizon(dtData, cXColumnName, cYColumnName, bandwidth = NULL,
  vcGroupingColumnNames = NULL)
}
\arguments{
\item{dtData}{Data set which may include other columns apart from date
and values.}

\item{cXColumnName}{Column name of dates.}

\item{cYColumnName}{Column name of values.}

\item{bandwidth}{the width of one band of Y values.
easier to differentiate between the bands.}

\item{vcGroupingColumnNames}{The set of columns which together define the group
for the chart to operate within If you plan to facet your plot,
you should specify the same column names to this argument.}
}
\value{
Returns a gpplot friendly object which means the user can use
ggplot scales, etc. to modify the look.
}
\description{
A horizon plot breaks the Y dimension down using colours. This is useful
when visualising y values spanning a vast range and / or trying to highlight
outliers without losing context of the rest of the data.  Horizon
plots are best viewed in an apsect ratio of very low vertical length.
}
\section{Cosmetic Tips}{
 The minimalist look can be achieved by appending the
following chunk of code to the example output object:
\code{
+
xlab(NULL) +
ylab(NULL) +
scale_fill_continuous(low = 'green', high = 'red') +
theme(
   axis.text = element_blank(),
   axis.ticks = element_blank(),
   legend.position = 'none',
   strip.background = element_blank(),
   # strip.text = element_blank(), # useful if only one year of data
   plot.background = element_blank(),
   panel.border = element_blank(),
   panel.background  = element_blank(),
   panel.grid = element_blank(),
   panel.border = element_blank()
) +
coord_fixed( 0.5 * diff(range(dfData$x)) / diff(range(dfData$y)))
}
}

\section{Also See}{
 \code{\link{stat_horizon}}, a less polished but more
flexible alternative.
}

\examples{
{
library(ggplot2)
set.seed(1)
dfData = data.frame(x = 1:1000, y = cumsum(rnorm(1000)))
p1 = ggplot_horizon(dfData, 'x', 'y')
p1
# add new geoms or colours
p1 +
geom_text(label = '!!!') +
scale_colour_continuous(low = 'red', high = 'green')
}
}
