% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{pbc_prtl_time}
\alias{pbc_prtl_time}
\title{A list of three \code{randomForestSRC::plot.variable} objects for the pbc data.}
\format{A randomForestSRC::plot.variable object for survival}
\description{
The \code{randomForestSRC::plot.variable} data set for the \code{pbc} survival dataset.
}
\details{
This cached data set is used by the vignette to demonstrate partial plots
at 1, 3 and 5 year survival for the top ranked minimal depth variables.
}
\examples{
\dontrun{
## Examples from randomForestSRC::rfsrc
##
data(pbc, package = "randomForestSRC")
pbc_rf <- rfsrc(Surv(days, status) ~ ., pbc, nsplit = 10)

pbc_vs <- var.select(pbc_rf)

xvar <- pbc_vs$topvars[1:6]

pbc_prtl_time <- mclapply(c(1,3,5), function(tm){
plot.variable(pbc_rf, surv.type = "surv",
             time = tm,
             xvar.names = xvar, partial = TRUE,
             show.plots = FALSE)
             })
 save(pbc_prtl_time, file="data/pbc_prtl_time.rda", compress="xz")
# Format for 1 year survival partial plot for ggRandomForests
gg_dta <- gg_partial(pbc_prtl_time[[1]])

# Without specifying which plot, plot.gg_partial returns a list of all four
# figures.
plot(gg_dta)

plot.gg_partial(gg_dta[[1]])
plot.gg_partial(gg_dta[[4]])

# Or a panel of the batch
plot(gg_dta, panel=TRUE)
}
}
\references{
Ishwaran H. and Kogalur U.B. (2014). Random Forests for
Survival, Regression and Classification (RF-SRC), R package
version 1.5.4.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests
for R. R News 7(2), 25-31.

Ishwaran H., Kogalur U.B., Blackstone E.H. and Lauer M.S.
(2008). Random survival forests. Ann. Appl. Statist. 2(3),
841-860.
}
\keyword{datasets}

