% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_plot.R
\name{lambda_plot}
\alias{lambda_plot}
\title{Lambda Plot: Trace of t-statistics}
\usage{
lambda_plot(
  model,
  lambda = seq(-2, 2, by = 0.1),
  color_palette = "viridis",
  alpha = 1,
  direction = 1,
  showplot = TRUE
)
}
\arguments{
\item{model}{Model of class "lm" or "glm"}

\item{lambda}{sequence of lambda values to consider for plot. Default is seq(-2,2,0.1)}

\item{color_palette}{A character string indicating the color map option to use.
Eight options are available: "viridis","cividis","magma","inferno","plasma","rocket","mako","turbo". Default is 'viridis'}

\item{alpha}{The alpha transparency, a number in [0,1]}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors are ordered from darkest to lightest. If -1, the order of colors is reversed}

\item{showplot}{logical indicating to show the main effect plots. If false, a list of tibbles is returned used to obtain the main effects for each factor. Default is TRUE}
}
\value{
Lambda plot for tracing t-staitics across different values of lambda (in ggplot2)
}
\description{
Lambda Plot: Trace of t-statistics
}
\examples{
mod <- lm(s2 ~ (A+B+C)^2,data=original_epitaxial)
lambda_plot(mod)
lambda_plot(mod,lambda = seq(0,2,0.1))
lambda_plot(mod,lambda = seq(0,2,0.1),showplot = FALSE)
}
