% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{error_catch}
\alias{error_catch}
\title{General Error Catching}
\usage{
error_catch(id, nsimul, intvars, interventions, int_times, int_descript,
  covnames, covtypes, basecovs, histvars, histories, compevent_model,
  hazardratio, intcomp, time_points, outcome_type, time_name, obs_data,
  parallel, ncores, nsamples, sim_data_b, outcome_name, compevent_name,
  comprisk, covmodels, histvals)
}
\arguments{
\item{id}{Character string specifying the name of the ID variable in \code{obs_data}.}

\item{nsimul}{Number of subjects for whom to simulate data.}

\item{intvars}{List, whose elements are vectors of character strings. The kth vector in \code{intvars} specifies the name(s) of the variable(s) to be intervened
on in each round of the simulation under the kth intervention in \code{interventions}.}

\item{interventions}{List, whose elements are lists of vectors. Each list in \code{interventions} specifies a unique intervention on the relevant variable(s) in \code{intvars}. Each vector contains a function
implementing a particular intervention on a single variable, optionally
followed by one or more "intervention values" (i.e.,
integers used to specify the treatment regime).}

\item{int_times}{List, whose elements are lists of vectors. The kth list in \code{int_times} corresponds to the kth intervention in \code{interventions}. Each vector specifies the time points in which the relevant intervention is applied on the corresponding variable in \code{intvars}.
When an intervention is not applied, the simulated natural course value is used. By default, this argument is set so that all interventions are applied in all time points.}

\item{int_descript}{Vector of character strings, each describing an intervention.}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates in \code{obs_data}.}

\item{covtypes}{Vector of character strings specifying the "type" of each time-varying covariate included in \code{covnames}. The possible "types" are: \code{"binary"}, \code{"normal"}, \code{"categorical"}, \code{"bounded normal"}, \code{"zero-inflated normal"}, \code{"truncated normal"}, \code{"absorbing"}, \code{"categorical time"}, and \code{"custom"}.}

\item{basecovs}{Vector of character strings specifying the names of baseline covariates in \code{obs_data}.}

\item{histvars}{List of vectors. The kth vector specifies the names of the variables for which the kth history function
in \code{histories} is to be applied.}

\item{histories}{Vector of history functions to apply to the variables specified in \code{histvars}.}

\item{compevent_model}{Model statement for the competing event variable.}

\item{hazardratio}{Logical scalar indicating whether the hazard ratio should be calculated
between two interventions.}

\item{intcomp}{List of two numbers indicating a pair of interventions to be compared by a hazard ratio.
The default is \code{NA}, resulting in no hazard ratio calculation.}

\item{time_points}{Number of time points to simulate.}

\item{outcome_type}{Character string specifying the "type" of the outcome. The possible "types" are: \code{"survival"}, \code{"continuous_eof"}, and \code{"binary_eof"}.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{obs_data}{Data table containing the observed data.}

\item{parallel}{Logical scalar indicating whether to parallelize simulations of
different interventions to multiple cores.}

\item{ncores}{Integer specifying the number of cores to use in parallel
simulation.}

\item{nsamples}{Integer specifying the number of bootstrap samples to generate.}

\item{sim_data_b}{Logical scalar indicating whether to return the simulated data set. If bootstrap samples are used (i.e., \code{nsamples} is set to a value greater than 0), this argument must be set to \code{FALSE}.}

\item{outcome_name}{Character string specifying the name of the outcome variable in \code{obs_data}.}

\item{compevent_name}{Character string specifying the name of the competing event variable in \code{obs_data}.}

\item{comprisk}{Logical scalar indicating the presence of a competing event.}

\item{covmodels}{Vector of model statements for the time-varying covariates.}

\item{histvals}{List of length 3. First element contains a vector of integers specifying the number of lags back for the lagged function. Second element contains
a vector of integers indicating the number of lags back for the lagavg function. The last element is an indicator whether a cumavg term
appears in any of the model statements.}
}
\value{
No value is returned.
}
\description{
This internal function catches various potential errors in the user input in \code{\link{gformula_survival}}, \code{\link{gformula_continuous_eof}}, and \code{\link{gformula_binary_eof}}.
}
\keyword{internal}
