% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive.R
\name{gfilinregPredictive}
\alias{gfilinregPredictive}
\title{Fiducial predictive distribution}
\usage{
gfilinregPredictive(fidsamples, newdata)
}
\arguments{
\item{fidsamples}{fiducial samples, the output of \code{\link{gfilinreg}}}

\item{newdata}{dataframe in which to look for variables with which to 
predict, or \code{NULL} if the model is intercept-only}
}
\value{
A list with two fields: \code{FPD}, a dataframe containing the 
  simulations, and \code{weight}, their weight. This is a 
  \code{gfilinreg} object.
}
\description{
Simulations of the fiducial predictive distribution.
}
\examples{
set.seed(666L)
x <- c(1, 2, 3, 4)
y <- x + 3 * rcauchy(4L)
gf <- gfilinreg(y ~ x, distr = "cauchy", L = 30L, nthreads = 2L)
gfpred <- gfilinregPredictive(gf, data.frame(x = c(4, 5)))
gfiSummary(gfpred)
}
