% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main1.R
\name{gfigpd1}
\alias{gfigpd1}
\title{Fiducial inference for the generalized Pareto model with known threshold}
\usage{
gfigpd1(
  X,
  beta,
  threshold,
  gamma.init = NA,
  sigma.init = NA,
  sd.gamma = NA,
  sd.sigma = NA,
  Jnumb = 50L,
  iter = 10000L,
  burnin = 2000L,
  thin = 6L,
  nchains = 4L,
  nthreads = parallel::detectCores(),
  seeds = NULL
)
}
\arguments{
\item{X}{numeric vector of data}

\item{beta}{vector of probabilities corresponding to the quantiles to be 
estimated}

\item{threshold}{value of the known threshold, must be smaller than the
maximum of \code{X}}

\item{gamma.init}{starting value for \code{gamma} in the MCMC}

\item{sigma.init}{starting value for \code{sigma} in the MCMC}

\item{sd.gamma}{standard deviation for the proposed \code{gamma} in the MCMC}

\item{sd.sigma}{standard deviation for the proposed \code{sigma} in the MCMC}

\item{Jnumb}{number of subsamples that are taken from the Jacobian}

\item{iter}{number of iterations per chain (burnin excluded)}

\item{burnin}{number of the first MCMC iterations discarded}

\item{thin}{thinning number for the MCMC chain. (e.g. if it is 1 no iteration 
is skipped)}

\item{nchains}{number of MCMC chains to run}

\item{nthreads}{number of threads to run the chains in parallel}

\item{seeds}{the seeds used for the MCMC sampler; one seed per chain, or 
\code{NULL} to use random seeds}
}
\value{
An object of class \code{\link[coda:mcmc]{mcmc}} if \code{nchains=1}, 
  otherwise an object of class \code{\link[coda:mcmc.list]{mcmc.list}}.
}
\description{
Runs the MCMC sampler of the fiducial distribution for the 
  generalized Pareto model with known threshold.
}
\examples{
set.seed(666L)
X <- rgpareto(200L, mu = 10, gamma = 0.5, sigma = 1)
gf <- gfigpd1(
  X, beta = c(0.98, 0.99), threshold = 10, 
  iter = 2000L, nchains = 2L, nthreads = 2L
) # note: 2*2000 iterations is not enough, I'm using these settings because 
  # of CRAN constraints (elapsed time must be < 5s)
summary(gf)
qgpareto(c(0.98, 0.99), mu = 10, gamma = 0.5, sigma = 1)
rejectionRate(gf)
HPDinterval(gf)
HPDinterval(joinMCMCchains(gf))
}
\references{
Damian V. Wandler & Jan Hannig. 
  \emph{Generalized fiducial confidence intervals for extremes}.
  Extremes (2012) 15:67–87.
  <doi:10.1007/s10687-011-0127-9>
}
