% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_prediction.R
\name{event_prediction_KM}
\alias{event_prediction_KM}
\title{Event prediction using a lifetable and a recruitment RCurve}
\usage{
event_prediction_KM(KMcurve, Survival = "Survival", Time = "Time",
  weighting = FALSE, Weights = "Weights", Weight_power = 1, rcurve,
  max_time = 100, dcurve = Blank(), type = c("automatic", "Weibull",
  "Lognormal"), startbeta = 1, startsigma = 1, condition = FALSE,
  cond_Events = 0, cond_NatRisk = NULL, cond_Time = 0,
  units = c("Days", "Months"), discountHR = 1)
}
\arguments{
\item{KMcurve}{The dataframe object containing the survival data}

\item{Survival}{The column name for the survival function (i.e. the probabilities). Default is "Survival"}

\item{Time}{The column name for the times. Default is "Time"
Alternatively accepts "Weibull" or "Lognormal" to force the type.}

\item{weighting}{Boolean for whether to use weighting. Default=TRUE as it greatly improves curve fitting.}

\item{Weights}{Name of Weights column. Default="Weights". Optional if weighting=FALSE. Recommended to use number at risk or remaining.}

\item{Weight_power}{Power to raise the weights to. Useful in large trials to give added weight to later points where numbers may still be high. Default=1 (Use weights as specified).}

\item{rcurve}{Observed and/or expected recruitment distribution as an RCurve object. This should typically be of PieceR type (piecewise linear recruitment).}

\item{max_time}{Maximum time to predict events up to.}

\item{dcurve}{Dropout/censoring distribution as a Curve object. This is Blank() by default, i.e. no dropout.}

\item{type}{Type of event curve to fit.Default is "Automatic", fitting both Weibull and Log-normal curves.}

\item{startbeta}{Starting value for the Weibull beta (shape) parameter to be used in the non-linear regression. Default=1 (exponential).}

\item{startsigma}{Starting value for the Lognormal sigma (sd) parameter to be used in the non-linear regression. Default=1.}

\item{condition}{Boolean whether to also do a conditional event prediction. Default=FALSE
Note that If all conditioning options are left as defaults, conditioned calculation will equal the unconditional one.}

\item{cond_Events}{Number of events to condition on. Default=0. Optional unless condition=TRUE.}

\item{cond_NatRisk}{Number of patients at risk to condition on. By default, the program will estimate the number at risk assuming no censoring.
It is highly recommended to specify this if conditioning. Default=NULL(takes value of N - cond_Events). Optional unless condition=TRUE.}

\item{cond_Time}{Time, in months, to condition on. Default=0. Optional unless condition=TRUE.}

\item{units}{Units that the KM-curve is specified in. Accepts "Days", "Months". Default="Days".}

\item{discountHR}{Hazard ratio for discounting events e.g. used to predict adjudicated events from unadjudicated data where patients remain 'at risk' after an event is adjudicated not to have occurred.
Values below 1 indicate fewer events will occur than predicted by the curve-fitting.
Note that changing this argument is only allowed if type="Weibull" since log-normal curves are not compatible with proportional hazards.
Default=1 (No discounting)}
}
\value{
Returns a list object with the fitted ecurve, the dcurve, the rcurve, the fitting details, and a summary table with one row per month up to max_time containing the following columns:
\itemize{
 \item{"Time"}{Time of assessment.}
 \item{"Patients"}{Number of patients recruited by the assessment time.}
 \item{"Predicted_Events"}{Number of events unconditionally predicted at the assessment time.}
 \item{"Conditioned_Events"}{Number of events unconditionally predicted at the assessment time (Column present only if conditioning specified).}
}
}
\description{
This is a function to perform event prediction\cr
It uses the fit_KM function to perform non-linear regression of Weibull and log-normal curves to the provided survival data.\cr
It creates an event Curve object from this, and combines it with a recruitment RCurve and an optional dropout(censoring) Curve.\cr
Using the same numerical integration approach as nph_curve_trajectories it performs an unconditional event prediction.\cr
If a conditioning time, event number (and preferably number at risk) are provided, a conditional event prediction is also calculated.\cr
}
\examples{
recruit <- PieceR(matrix(c(rep(1,12),10,15,25,30,45,60,55,50,65,60,55,30),ncol=2),1)
example_data_short <- simulate_trials(active_ecurve=Weibull(50,0.8),control_ecurve=Weibull(50,0.8),
rcurve=recruit, assess=10,iterations=1,seed=12345,detailed_output=TRUE)

library(survival)

temp1 <- summary(survfit(Surv(example_data_short[,"Time"],1-example_data_short[,"Censored"])~ 1,
error="greenwood"))
out1 <- cbind(temp1$time,temp1$n.risk,temp1$surv,temp1$std.err)
out1 <- rbind(c(0,out1[1,2],1,0),out1)
colnames(out1) <- c("Time","NAR","Survival","Std.Err")
x1 <- ceiling(max(out1[,"Time"]))
example_lifetable <- out1[findInterval(0:x1,out1[,"Time"]),]
example_lifetable[,"Time"] <- 0:x1

event_prediction_KM(KMcurve=example_lifetable, weighting=TRUE, Weights="NAR", rcurve=recruit,
max_time=60, type="automatic", condition=TRUE, cond_Events=49, cond_NatRisk=451, cond_Time=10, 
units="Months")
}
\author{
James Bell
}
