% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_prediction.R
\name{event_prediction}
\alias{event_prediction}
\title{Event prediction using patient-level survival data and a recruitment RCurve}
\usage{
event_prediction(data, Time = "Time", Event = "Event",
  censoringOne = FALSE, type = c("automatic", "Weibull", "Lognormal"),
  rcurve, max_time = 100, dcurve = Blank(), CI = 0.95,
  condition = FALSE, cond_Events = 0, cond_NatRisk = NULL,
  cond_Time = 0, units = c("Days", "Months"), init = NULL,
  discountHR = 1)
}
\arguments{
\item{data}{The dataframe object containing the patient-level survival data}

\item{Time}{The column name for the times. Default is "Time"}

\item{Event}{The column name for the events column (i.e. the binary variable denoting events vs censorings). Default is "Event"}

\item{censoringOne}{Specify whether censoring is denoted in the Event column by a one (TRUE) or zero (FALSE). Default=FALSE (censorings denoted by 0, events by 1)}

\item{type}{Type of event curve to fit. Default is "Automatic", fitting both Weibull and Log-normal curves.
Alternatively accepts "Weibull" or "Lognormal" to force the type.}

\item{rcurve}{Observed and/or expected recruitment distribution as an RCurve object. This should typically be of PieceR type (piecewise linear recruitment).}

\item{max_time}{Maximum time to predict events up to.}

\item{dcurve}{Dropout/censoring distribution as a Curve object. This is Blank() by default, i.e. no dropout.}

\item{CI}{Number between 0 and 1 for the size of CI to calculate. Default is 0.95 (95 percent CI).}

\item{condition}{Boolean whether to also do a conditional event prediction. Default=FALSE
Note that If all conditioning options are left as defaults, conditioned calculation will equal the unconditional one.}

\item{cond_Events}{Number of events to condition on. Default=0. Optional unless condition=TRUE.}

\item{cond_NatRisk}{Number of patients at risk to condition on. Default=-1.
By default, the program will estimate the number at risk assuming no censoring. It is highly recommended to specify this if conditioning. Optional unless condition=TRUE.}

\item{cond_Time}{Time, in months, to condition on. Default=0. Optional unless condition=TRUE.}

\item{units}{Units that the KM-curve is specified in. Accepts "Days", "Months". Default="Days".}

\item{init}{Vector of starting values for parameter values; useful if survreg experiences convergence issues. Default=NULL (no values specified)}

\item{discountHR}{Hazard ratio for discounting events e.g. used to predict adjudicated events from unadjudicated data where patients remain 'at risk' after an event is adjudicated not to have occurred.
Values below 1 indicate fewer events will occur than predicted by the curve-fitting.
Note that changing this argument is only allowed if type="Weibull" since log-normal curves are not compatible with proportional hazards.
Default=1 (No discounting)}
}
\value{
Returns a list object with the fitted ecurve, the dcurve, the rcurve and a summary table with one row per month up to max_time containing the following columns:
\itemize{
 \item{"Assessment_Time"}{Time of assessment.}
 \item{"Patients"}{Number of patients recruited by the assessment time.}
 \item{"Predicted_Events"}{Number of events unconditionally predicted at the assessment time.}
 \item{"SE_Fitting"}{SE of the estimate of the fitted mean. Note that this corresponds to the accuracy of the estimate of the underlying parameter, not future observed event numbers.}
 \item{"SE_Prediction"}{SE of event prediction.}
 \item{"Prediction_Lower"}{Lower bound of X percent CI of unconditional event prediction, where X is the 'CI' argument. This CI is based on the quantiles of the beta-binomial distribution and hence is asymmetric about the predicted event number.}
 \item{"Prediction_Upper"}{Upper bound of X percent CI of unconditional event prediction, where X is the 'CI' argument. This CI is based on the quantiles of the beta-binomial distribution and hence is asymmetric about the predicted event number.}
 \item{"Conditioned_Events"}{Number of events unconditionally predicted at the assessment time (Column present only if conditioning specified).}
 \item{"Cond_SE_Fitting"}{SE of the estimate of the fitted conditional mean. Note that this corresponds to the accuracy of the estimate of the underlying parameter, not future observed event numbers (Column present only if conditioning specified).}
 \item{"Cond_SE_Prediction"}{SE of the conditional event prediction (Column present only if conditioning specified).}
 \item{"Cond_Prediction_Lower"}{Lower bound of X percent CI of conditional event prediction, where X is the 'CI' argument. This CI is based on the quantiles of the beta-binomial distribution and hence is asymmetric about the predicted event number.}
 \item{"Cond_Prediction_Upper"}{Upper bound of X percent CI of conditional event prediction, where X is the 'CI' argument. This CI is based on the quantiles of the beta-binomial distribution and hence is asymmetric about the predicted event number.}
}
}
\description{
This is a function to perform event prediction\cr
It uses the fit_KM_tte_data function to perform MLE regression of Weibull and log-normal curves to the provided survival data.\cr
It creates an event Curve object from this, and combines it with a recruitment RCurve and an optional dropout(censoring) Curve.\cr
Using the same numerical integration approach as nph_curve_trajectories it performs an unconditional event prediction.\cr
If a conditioning time, event number (and preferably number at risk) are provided, a conditional event prediction is also calculated.\cr
Analytic standard errors for conditional and unconditional event numbers are provided for the whole trajectory.\cr
SEs calculated by propagating parameter estimate errors through the integrals by the delta method and then invoking a beta-binomial distribution.\cr\cr
For event prediction, conditional predictions with the Conditional SE of Prediction are most accurate and appropriate.\cr
Unconditional predictions should be close to conditional ones but technically relate to predictions if the trial were rerun, rather than this specific instance.
Point estimates are usually very close to the unconditional ones, but the CIs are typically much wider than necessary.
The conditional and unconditional SEs of fitting relate to the accuracy of the estimated mean event number at a given time, rather than the spread of future observations.
The conditional and unconditional SEs of prediction relate to the accuracy of prediction of future observations, and should therefore be used for event prediction.
Note that the Prediction SEs are wider than the Fitting SEs as they also take into account the binomial uncertainty of events occurring (beta-binomial model).
}
\examples{
recruit <- PieceR(matrix(c(rep(1,12),10,15,25,30,45,60,55,50,65,60,55,30),ncol=2),1)
trial_short <- simulate_trials(active_ecurve=Weibull(50,0.8),control_ecurve=Weibull(50,0.8),
rcurve=recruit, assess=10,iterations=1,seed=12345,detailed_output=TRUE)

predictions <- event_prediction(data=trial_short, Event="Censored", censoringOne=TRUE, 
type="Weibull", rcurve=recruit, max_time=60, condition=TRUE, cond_Events=49, cond_NatRisk=451, 
cond_Time=10, units="Months")
}
\references{
Bell J, unpublished work.
}
\author{
James Bell
}
