% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSDatastoreManager.R
\docType{class}
\name{GSDataStoreManager}
\alias{GSDataStoreManager}
\title{Geoserver REST API DataStore Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for managing GeoServer
DataStores (i.e. stores of vector data)
}
\description{
Geoserver REST API DataStore Manager

Geoserver REST API DataStore Manager
}
\examples{
\dontrun{
   GSDataStoreManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSDataStoreManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSDataStoreManager-getDataStores}{\code{GSDataStoreManager$getDataStores()}}
\item \href{#method-GSDataStoreManager-getDataStoreNames}{\code{GSDataStoreManager$getDataStoreNames()}}
\item \href{#method-GSDataStoreManager-getDataStore}{\code{GSDataStoreManager$getDataStore()}}
\item \href{#method-GSDataStoreManager-createDataStore}{\code{GSDataStoreManager$createDataStore()}}
\item \href{#method-GSDataStoreManager-updateDataStore}{\code{GSDataStoreManager$updateDataStore()}}
\item \href{#method-GSDataStoreManager-deleteDataStore}{\code{GSDataStoreManager$deleteDataStore()}}
\item \href{#method-GSDataStoreManager-getFeatureTypes}{\code{GSDataStoreManager$getFeatureTypes()}}
\item \href{#method-GSDataStoreManager-getFeatureTypeNames}{\code{GSDataStoreManager$getFeatureTypeNames()}}
\item \href{#method-GSDataStoreManager-getFeatureType}{\code{GSDataStoreManager$getFeatureType()}}
\item \href{#method-GSDataStoreManager-createFeatureType}{\code{GSDataStoreManager$createFeatureType()}}
\item \href{#method-GSDataStoreManager-updateFeatureType}{\code{GSDataStoreManager$updateFeatureType()}}
\item \href{#method-GSDataStoreManager-deleteFeatureType}{\code{GSDataStoreManager$deleteFeatureType()}}
\item \href{#method-GSDataStoreManager-publishLayer}{\code{GSDataStoreManager$publishLayer()}}
\item \href{#method-GSDataStoreManager-unpublishLayer}{\code{GSDataStoreManager$unpublishLayer()}}
\item \href{#method-GSDataStoreManager-uploadData}{\code{GSDataStoreManager$uploadData()}}
\item \href{#method-GSDataStoreManager-uploadShapefile}{\code{GSDataStoreManager$uploadShapefile()}}
\item \href{#method-GSDataStoreManager-uploadProperties}{\code{GSDataStoreManager$uploadProperties()}}
\item \href{#method-GSDataStoreManager-uploadH2}{\code{GSDataStoreManager$uploadH2()}}
\item \href{#method-GSDataStoreManager-uploadSpatialite}{\code{GSDataStoreManager$uploadSpatialite()}}
\item \href{#method-GSDataStoreManager-uploadAppschema}{\code{GSDataStoreManager$uploadAppschema()}}
\item \href{#method-GSDataStoreManager-uploadGeoPackage}{\code{GSDataStoreManager$uploadGeoPackage()}}
\item \href{#method-GSDataStoreManager-clone}{\code{GSDataStoreManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR"><a href='../../geosapi/html/GSManager.html#method-GSManager-ERROR'><code>geosapi::GSManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO"><a href='../../geosapi/html/GSManager.html#method-GSManager-INFO'><code>geosapi::GSManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN"><a href='../../geosapi/html/GSManager.html#method-GSManager-WARN'><code>geosapi::GSManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect"><a href='../../geosapi/html/GSManager.html#method-GSManager-connect'><code>geosapi::GSManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName"><a href='../../geosapi/html/GSManager.html#method-GSManager-getClassName'><code>geosapi::GSManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getCoverageStoreManager'><code>geosapi::GSManager$getCoverageStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getDataStoreManager'><code>geosapi::GSManager$getDataStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getNamespaceManager'><code>geosapi::GSManager$getNamespaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getServiceManager'><code>geosapi::GSManager$getServiceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getStyleManager'><code>geosapi::GSManager$getStyleManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus"><a href='../../geosapi/html/GSManager.html#method-GSManager-getSystemStatus'><code>geosapi::GSManager$getSystemStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl"><a href='../../geosapi/html/GSManager.html#method-GSManager-getUrl'><code>geosapi::GSManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getWorkspaceManager'><code>geosapi::GSManager$getWorkspaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize"><a href='../../geosapi/html/GSManager.html#method-GSManager-initialize'><code>geosapi::GSManager$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger"><a href='../../geosapi/html/GSManager.html#method-GSManager-logger'><code>geosapi::GSManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor"><a href='../../geosapi/html/GSManager.html#method-GSManager-monitor'><code>geosapi::GSManager$monitor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload"><a href='../../geosapi/html/GSManager.html#method-GSManager-reload'><code>geosapi::GSManager$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-getDataStores"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-getDataStores}{}}}
\subsection{Method \code{getDataStores()}}{
Get the list of available dataStores.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getDataStores(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{list} giving items of class \code{\link{GSAbstractDataStore}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-getDataStoreNames"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-getDataStoreNames}{}}}
\subsection{Method \code{getDataStoreNames()}}{
Get the list of available dataStore names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getDataStoreNames(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-getDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-getDataStore}{}}}
\subsection{Method \code{getDataStore()}}{
Get an object of class \code{\link{GSAbstractDataStore}} given a workspace and datastore names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getDataStore(ws, ds)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the datastore
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-createDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-createDataStore}{}}}
\subsection{Method \code{createDataStore()}}{
Creates a datastore given a workspace and an object of class \code{\link{GSAbstractDataStore}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$createDataStore(ws, dataStore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{dataStore}}{datastore object of class \link{GSAbstractDataStore}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-updateDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-updateDataStore}{}}}
\subsection{Method \code{updateDataStore()}}{
Updates a datastore given a workspace and an object of class \code{\link{GSAbstractDataStore}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$updateDataStore(ws, dataStore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{dataStore}}{datastore object of class \link{GSAbstractDataStore}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-deleteDataStore"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-deleteDataStore}{}}}
\subsection{Method \code{deleteDataStore()}}{
Deletes a datastore given workspace and datastore names.
   By defaut, the option \code{recurse} is set to FALSE, ie datastore layers are not removed.
   To remove all datastore layers, set this option to TRUE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$deleteDataStore(ws, ds, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{recurse}}{recurse}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-getFeatureTypes"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-getFeatureTypes}{}}}
\subsection{Method \code{getFeatureTypes()}}{
Get the list of available feature types for given workspace and datastore.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getFeatureTypes(ws, ds, list = "configured")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{list}}{list type value, among "configured", "available", "available_with_geom", "all"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{list} giving items of class \code{\link{GSFeatureType}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-getFeatureTypeNames"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-getFeatureTypeNames}{}}}
\subsection{Method \code{getFeatureTypeNames()}}{
Get the list of available feature type names for given workspace and datastore.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getFeatureTypeNames(ws, ds)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a vector of class\code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-getFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-getFeatureType}{}}}
\subsection{Method \code{getFeatureType()}}{
Get an object of class \code{\link{GSFeatureType}} given a workspace, datastore and feature type names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$getFeatureType(ws, ds, ft)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{ft}}{feature type name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSFeatureType}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-createFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-createFeatureType}{}}}
\subsection{Method \code{createFeatureType()}}{
Creates a new featureType given a workspace, datastore names and an object of class \code{\link{GSFeatureType}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$createFeatureType(ws, ds, featureType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{featureType}}{feature type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-updateFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-updateFeatureType}{}}}
\subsection{Method \code{updateFeatureType()}}{
Updates a featureType given a workspace, datastore names and an object of class \code{\link{GSFeatureType}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$updateFeatureType(ws, ds, featureType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{featureType}}{feature type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-deleteFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-deleteFeatureType}{}}}
\subsection{Method \code{deleteFeatureType()}}{
Deletes a featureType given a workspace, datastore names, and an object of 
   class \code{\link{GSFeatureType}}. By defaut, the option \code{recurse} is 
   set to FALSE, ie datastore layers are not removed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$deleteFeatureType(ws, ds, ft, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{ft}}{feature type name}

\item{\code{recurse}}{recurse}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-publishLayer"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-publishLayer}{}}}
\subsection{Method \code{publishLayer()}}{
Publish a feature type/layer pair given a workspace and datastore. The name 'layer' here 
encompasses both \link{GSFeatureType} and \link{GSLayer} resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$publishLayer(ws, ds, featureType, layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{featureType}}{object of class \link{GSFeatureType}}

\item{\code{layer}}{object of class \link{GSLayer}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if published, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-unpublishLayer"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-unpublishLayer}{}}}
\subsection{Method \code{unpublishLayer()}}{
Unpublish a feature type/layer pair given a workspace and datastore. The name 'layer' here 
encompasses both \link{GSFeatureType} and \link{GSLayer} resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$unpublishLayer(ws, ds, lyr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{lyr}}{layer name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if published, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-uploadData"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-uploadData}{}}}
\subsection{Method \code{uploadData()}}{
Uploads features data. The \code{extension} corresponds to the format/type of features to be uploaded among "shp", "spatialite", "h2", "gpkg". 
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadData(
  ws,
  ds,
  endpoint = "file",
  extension,
  configure = "first",
  update = "append",
  filename,
  charset,
  contentType
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{extension}}{extension}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}

\item{\code{contentType}}{content type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-uploadShapefile"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-uploadShapefile}{}}}
\subsection{Method \code{uploadShapefile()}}{
Uploads zipped shapefile.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadShapefile(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-uploadProperties"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-uploadProperties}{}}}
\subsection{Method \code{uploadProperties()}}{
Uploads properties.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadProperties(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-uploadH2"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-uploadH2}{}}}
\subsection{Method \code{uploadH2()}}{
Uploads H2 database.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadH2(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-uploadSpatialite"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-uploadSpatialite}{}}}
\subsection{Method \code{uploadSpatialite()}}{
Uploads spatialite file.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadSpatialite(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-uploadAppschema"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-uploadAppschema}{}}}
\subsection{Method \code{uploadAppschema()}}{
Uploads App schema.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadAppschema(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-uploadGeoPackage"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-uploadGeoPackage}{}}}
\subsection{Method \code{uploadGeoPackage()}}{
Uploads GeoPackage.
   The \code{endpoint} takes a value among \code{"file"} (default), \code{"url"} or \code{"external"}. The \code{filename} is the name 
   of the coverage file to upload and set for the newly created datastore. The \code{configure} parameter can take a value among values 
   \code{"none"} (indicates to configure only the datastore but no layer configuration) or \code{"first"} (configure 
   both datastore and layer). The \code{update} defines the strategy for the upload: \code{"append"} (default value) for 
   the first upload, \code{"overwrite"} in case the file should be overwriten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$uploadGeoPackage(
  ws,
  ds,
  endpoint = "file",
  configure = "first",
  update = "append",
  filename,
  charset = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{ds}}{datastore name}

\item{\code{endpoint}}{endpoint}

\item{\code{configure}}{configure strategy among values: "first" or "none"}

\item{\code{update}}{update strategy, among values: "append", "overwrite"}

\item{\code{filename}}{file name of the resource to upload}

\item{\code{charset}}{charset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if uploaded, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDataStoreManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSDataStoreManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDataStoreManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
