% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GSVersion.R
\docType{class}
\name{GSVersion}
\alias{GSVersion}
\title{A GeoServer version}
\format{\code{\link{R6Class}} object.}
\usage{
GSVersion
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer version
}
\description{
This class allows to grab the GeoServer version. By default, a
tentative is made to fetch version from web admin default page, since Geoserver
REST API did not support GET operation for the Geoserver version in past releases
of Geoserver.
}
\details{
Geoserver REST API - Geoserver Version
}
\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd)}}{
   This method is used to instantiate a GSVersion object.
 }
 \item{\code{lowerThan(version)}}{
   Compares to a version and returns TRUE if it is lower, FALSE otherwise
 }
 \item{\code{greaterThan(version)}}{
   Compares to a version and returns TRUE if it is greater, FALSE otherwise
 }
 \item{\code{equalTo(version)}}{
   Compares to a version and returns TRUE if it is equal, FALSE otherwise
 }
}
}
\examples{
\dontrun{
version <- GSVersion$new(
             url = "http://localhost:8080/geoserver",
             user = "admin", pwd = "geoserver"
           )
}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{version}

