% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GSLayerGroup.R
\docType{class}
\name{GSLayerGroup}
\alias{GSLayerGroup}
\title{A GeoServer layergroup resource}
\format{\code{\link{R6Class}} object.}
\usage{
GSLayerGroup
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer layergroup
}
\description{
This class models a GeoServer layer group. This class is to be
used for clustering layers into a group.
}
\details{
Geoserver REST API LayerGroup
}
\section{Methods}{

\describe{
 \item{\code{new(rootName, xml)}}{
   This method is used to instantiate a GSLayer
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSLayer from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSLayer to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
 \item{\code{setName(name)}}{
   Sets the name.
 }
 \item{\code{setTitle(title)}}{
   Sets the title.
 }
 \item{\code{setAbstract(abstract)}}{
   Sets the abstract.
 }
 \item{\code{setMode(mode)}}{
   Sets the mode.
 }
 \item{\code{setWorkspace(ws)}}{
   Sets the worksapce
 }
 \item{\code{addLayer(layer)}}{
   Adds a layer
 }
 \item{\code{delLayer(layer)}}{
   Deletes a layer
 }
 \item{\code{addLayerGroup(layerGroup)}}{
   Adds a layer group
 }
 \item{\code{delLayerGroup(layerGroup)}}{
   Deletes a layer group
 }
 \item{\code{setStyles(styles)}}{
   Sets a list of optional styles
 }
 \item{\code{addStyle(style)}}{
   Sets an available style. Returns TRUE if set, FALSE otherwise
 }
 \item{\code{delStyle(name)}}{
   Deletes an available. Returns TRUE if deleted, FALSE otherwise
 }
 \item{\code{setMetadataLinks(metadataLinks)}}{
   Sets a list of \code{GSMetadataLinks}
 }
 \item{\code{addMetadataLink(metadataLink)}}{
   Adds a metadataLink
 }
 \item{\code{delMetadataLink(metadataLink)}}{
   Deletes a metadataLink
 }
 \item{\code{setBounds(minx, miny, maxx, maxy, bbox, crs)}}{
   Sets the layer group bounds. Either from coordinates or from
   a \code{bbox} object (matrix).
 }
}
}
\examples{
lyr <- GSLayerGroup$new()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{coverage}
\keyword{featureType}
\keyword{geoserver}
\keyword{group}
\keyword{layer}
\keyword{resource}
\keyword{rest}

