% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/procD.pgls.r
\name{procD.pgls}
\alias{procD.pgls}
\title{Phylogenetic ANOVA/regression for shape data}
\usage{
procD.pgls(f1, phy, iter = 999, int.first = FALSE, RRPP = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{f1}{A formula for the linear model (e.g., y~x1+x2)}

\item{phy}{A phylogenetic tree of {class phylo} - see \code{\link[ape]{read.tree}} in library ape}

\item{iter}{Number of iterations for significance testing}

\item{int.first}{A logical value to indicate if interactions of first main effects should precede subsequent main effects}

\item{RRPP}{a logical value indicating whether residual randomization should be used for significance testing}

\item{verbose}{A logical value specifying whether additional output should be displayed}

\item{...}{Arguments passed on to procD.fit (typically associated with the lm function)}
}
\value{
Function returns an ANOVA table of statistical results for all factors: df (for each factor), SS, MS,
F ratio, Prand, and Rsquare.
}
\description{
Function performs Procrustes ANOVA in a phylogenetic framework and uses  permutation procedures to assess
statistical hypotheses describing patterns of shape variation and covariation for a set of Procrustes-aligned coordinates
}
\details{
The function performs ANOVA and regression models in a phylogenetic context under a Brownian motion model of evolution,
in a manner that can accommodate
high-dimensional datasets. The approach is derived from the statistical equivalency between parametric methods
utilizing covariance matrices and methods based on distance matrices (Adams 2014). Data input is specified by
a formula (e.g., y~X), where 'y' specifies the response variables (shape data), and 'X' contains one or more
independent variables (discrete or continuous). The response matrix 'y' can be either in the form of a two-dimensional data
  matrix of dimension (n x [p x k]), or a 3D array (p x n x k).  It is assumed that the landmarks have previously
  been aligned using Generalized Procrustes Analysis (GPA) [e.g., with \code{\link{gpagen}}].
  Linear model fits (using the  \code{\link{lm}} function)
  can also be input in place of a formula.  Arguments for \code{\link{lm}} can also be passed on via this function.
  The user must also specify a phylogeny describing the evolutionary relationships among species (of class phylo).
  Note that the specimen labels for both x and y must match the labels on the tips of the phylogeny.

From the phylogeny, a phylogenetic transformation matrix is obtained under a Brownian motion model, and used to
  transform the x and y variables. Next, the Gower-centered distance matrix is obtained from predicted values from the
  model (y~x), from which sums-of-squares, F-ratios, and R^2 are estimated for each factor in the model (see Adams, 2014).
  Data are then permuted across the tips of the phylogeny, and estimates of statistical values are obtained for the permuted data,
  which are  compared to the observed value to assess significance.

Two possible resampling procedures are provided. First, if RRPP=FALSE,
  the rows of the matrix of shape variables
  are randomized relative to the design matrix. This is analogous to a 'full' randomization. Second, if RRPP=TRUE,
  a residual randomization permutation procedure is utilized (Collyer et al. 2014). Here, residual shape values from a reduced model are
  obtained, and are randomized with respect to the linear model under consideration. These are then added to
  predicted values from the remaining effects to obtain pseudo-values from which SS are calculated. NOTE: for
  single-factor designs, the two approaches are identical.  However, when evaluating factorial models it has been
  shown that RRPP attains higher statistical power and thus has greater ability to identify patterns in data should
  they be present (see Anderson and terBraak 2003). Effect-sizes (Z-scores) are computed as standard deviates of the sampling
  distributions (of F values) generated, which might be more intuitive for P-values than F-values (see Collyer et al. 2014).  In the case
  that multiple factor or factor-covariate interactions are used in the model formula, one can specify whether all main effects should be
   added to the model first, or interactions should precede subsequent main effects
  (i.e., Y ~ a + b + c + a:b + ..., or Y ~ a + b + a:b + c + ..., respectively.)
}
\examples{
### Example of D-PGLS for high-dimensional data
data(plethspecies)
Y.gpa<-gpagen(plethspecies$land)    #GPA-alignment
procD.pgls(Y.gpa$coords ~ Y.gpa$Csize,plethspecies$phy,iter=49)

### Example of D-PGLS for high-dimensional data, using RRPP
procD.pgls(Y.gpa$coords ~ Y.gpa$Csize,plethspecies$phy,iter=49,RRPP=TRUE)
}
\author{
Dean Adams and Michael Collyer
}
\references{
Adams, D.C. 2014. A method for assessing phylogenetic least squares models for shape and other high-dimensional
multivariate data. Evolution. 68:2675-2688.

Collyer, M.L., D.J. Sekora, and D.C. Adams. 2015. A method for analysis of phenotypic change for phenotypes described
by high-dimensional data. Heredity. 115:357-365.
}
\keyword{analysis}

