% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODataQualityAbstractElement.R
\docType{class}
\name{ISODataQualityAbstractElement}
\alias{ISODataQualityAbstractElement}
\title{ISODataQualityAbstractElement}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISODataQualityAbstractElement
}
\description{
ISODataQualityAbstractElement
}
\section{Fields}{

\describe{
\item{\code{nameOfMeasure}}{[\code{\link{character}}] measure name}

\item{\code{measureIdentification}}{[\code{\link{ISOMetaIdentifier}}] measure identification}

\item{\code{measureDescription}}{[\code{\link{character}}] measure description}

\item{\code{evaluationMethodType}}{[\code{\link{ISOEvaluationMethodType}}] measure evaluation method type}

\item{\code{evaluationMethodDescription}}{[\code{\link{character}}] measure evaluation method description}

\item{\code{evaluationProcedure}}{[\code{\link{character}}] evaluation procedure}

\item{\code{dateTime}}{[\code{\link{POSIXt}}] dateTime}

\item{\code{result}}{[\code{\link{ISOConformanceResult}}] conformance result(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISODataQuality
 }
 \item{\code{addNameOfMeasure(name, locales)}}{
   Add name. Locale names can be specified as \code{list} with 
   the \code{locales} argument.
 }
 \item{\code{delNameOfMeasure(name, locales)}}{
   Deletes name. Locale names can be  specified as \code{list} with 
   the \code{locales} argument. Local names should match those of 
   the name to be deleted, otherwise nothing will be deleted.
 }
 \item{\code{setMeasureIdentification(identification)}}{
   Sets measure identifier, an object of class \code{ISOMetaIdentifier}
 }
 \item{\code{setMeasureDescription(description, locales)}}{
   Sets measure description. Locale names can be specified as \code{list} with 
   the \code{locales} argument.
 }
 \item{\code{setEvaluationMethodType(type)}}{
   Sets the type of evaluation method, an object of class \code{ISOEvaluationMethodType}
   or any \code{character} value among code{ISOEvaluationMethodType$values()}
 }
 \item{\code{setEvaluationMethodDescription(description, loales)}}{
   Sets the description of evaluation method. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setEvaluationMethodProcedure(procedure)}}{
   Sets the procedure as an object of class \code{ISOCitation}
 }
 \item{\code{setDateTime(dateTime)}}{
   Sets datetime, object class 'POSIXct'/'POSIXt'
 }
 \item{\code{addResult(result)}}{
   Sets conformance result, object of class \code{ISOConformanceResult}
 }
 \item{\code{delResult(result)}}{
   Deletes conformance result, object of class \code{ISOConformanceResult}
 }
}
}

\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{abstract}
\keyword{data}
\keyword{element}
\keyword{quality}
