% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryNominalResolution.R
\docType{class}
\name{ISOImageryNominalResolution}
\alias{ISOImageryNominalResolution}
\title{ISOImageryNominalResolution}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery nominal resolution
}
\description{
ISOImageryNominalResolution
}
\section{Fields}{

\describe{
\item{\code{scanningResolution}}{[\code{\link{ISODistance}}]}

\item{\code{groundResolution}}{[\code{\link{ISODistance}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryNominalResolution}}
 }
 \item{\code{setScanningResolution(resolution)}}{
   Set the scanning resolution, object of class \code{\link{ISODistance}}
 }
 \item{\code{setGroundResolution(resolution)}}{
   Set the ground resolution, object of class \code{\link{ISODistance}}
 }
}
}

\examples{
  #encoding
  dq <- ISOImageryNominalResolution$new()
  d <- ISODistance$new(value = 1, uom = "m", useUomURI = TRUE)
  dq$setScanningResolution(d)
  dq$setGroundResolution(d)
  
  #xml
  xml <- dq$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{imagery}
\keyword{nominal}
\keyword{resolution}
