% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOFeatureType.R
\docType{class}
\name{ISOFeatureType}
\alias{ISOFeatureType}
\title{ISOFeatureType}
\format{\code{\link{R6Class}} object.}
\usage{
ISOFeatureType
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO FeatureType
}
\description{
ISOFeatureType
}
\section{Fields}{

\describe{
\item{\code{typeName}}{}

\item{\code{definition}}{}

\item{\code{code}}{}

\item{\code{isAbstract}}{}

\item{\code{aliases}}{}

\item{\code{inheritsFrom}}{}

\item{\code{inheritsTo}}{}

\item{\code{featureCatalogue}}{}

\item{\code{constrainedBy}}{}

\item{\code{definitionReference}}{}

\item{\code{carrierOfCharacteristics}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOFeatureType
 }
 \item{\code{setTypeName(typeName)}}{
   Sets the type name. Object of class \code{ISOLocalName} or \code{"character"}
 }
 \item{\code{setDefinition(definition)}}{
   Sets the definition
 }
 \item{\code{setCode(code)}}{
   Sets the code
 }
 \item{\code{setIsAbstract(isAbstract)}}{
   Sets TRUE/FALSE if the feature type is abstract or not
 }
 \item{\code{addAlias(alias)}}{
   Set alias name. Object of class \code{ISOLocalName} or \code{"character"}
 }
 \item{\code{delAlias(alias)}}{
   Deletes alias name
 }
 \item{\code{setFeatureCatalogue(fc)}}{
   Sets a feature catalogue, object of class \code{ISOFeatureCatalogue}
 }
 \item{\code{addConstraint(constraint)}}{
   Adds a constraint, object of class \code{ISOConstraint} or \code{character}
 }
 \item{\code{delConstraint(constraint)}}{
   Deletes a constraint, object of class \code{ISOConstraint} or \code{character}
 }
 \item{\code{setDefinitionReference(definitionReference)}}{
   Sets the definition Reference, object of class \code{ISODefinitionReference}
 }
 \item{\code{addCharacteristic(characteristic)}}{
   Adds a characteristic as object of class \code{ISOPropertyType} or subclass
 }
 \item{\code{delCharacteristic(characteristic)}}{
   Deletes a characteristic as object of class \code{ISOPropertyType} or subclass
 }
}
}
\examples{
#featuretype
 md <- ISOFeatureType$new()
 md$setTypeName("typeName")
 md$setDefinition("definition")
 md$setCode("code")
 md$setIsAbstract(FALSE)
 md$addAlias("alias1")
 md$addAlias("alias2")

 #add feature attributes
 for(i in 1:3){
   #create attribute
   fat <- ISOFeatureAttribute$new()
   fat$setMemberName(sprintf("name \%s",i))
   fat$setDefinition(sprintf("definition \%s",i))
   fat$setCardinality(lower=1,upper=1)
   fat$setCode(sprintf("code \%s",i))

   #add measurement unit
   gml <- GMLBaseUnit$new(id = "ID\%")
   gml$setDescriptionReference("someref")
   gml$setIdentifier("identifier", "codespace")
   gml$addName("name1", "codespace")
   gml$addName("name2", "codespace")
   gml$setQuantityTypeReference("someref")
   gml$setCatalogSymbol("symbol")
   gml$setUnitsSystem("somelink")
   fat$setValueMeasurementUnit(gml)

   #add listed values
   val1 <- ISOListedValue$new()
   val1$setCode("code1")
   val1$setLabel("label1")
   val1$setDefinition("definition1")
   fat$addListedValue(val1)
   val2 <- ISOListedValue$new()
   val2$setCode("code2")
   val2$setLabel("label2")
   val2$setDefinition("definition2")
   fat$addListedValue(val2)
   fat$setValueType("typeName")

   #add feature attribute as carrierOfCharacteristic
   md$addCharacteristic(fat)
 }
 xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\keyword{ISO}
\keyword{feature}
\keyword{type}

