% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOMetadataElement.R
\docType{class}
\name{ISOMetadataElement}
\alias{ISOMetadataElement}
\title{ISOMetadataElement}
\format{\code{\link{R6Class}} object.}
\usage{
ISOMetadataElement
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Metadata Element
}
\description{
ISOMetadataElement
}
\note{
Abstract ISO Metadata class used internally by geometa
}
\section{Static Methods}{

\describe{
 \item{\code{getISOClassByNode(node)}}{
   Inherit the ISO class matching an XML document or node
 }
 \item{\code{compare(metadataElement1, metadataElement2)}}{
   Compares two metadata elements objects. Returns TRUE if they are equal,
   FALSE otherwise. The comparison of object is done by comparing the XML
   representation of the objects (since no R6 object comparison method seems
   to exist)
 }
}
}

\section{Abstract Methods}{

\describe{
 \item{\code{new(xml, element, namespace)}}{
   This method is used to instantiate an ISOMetadataElement
 }
 \item{\code{decode(xml)}}{
   Decodes a ISOMetadata* R6 object from XML representation
 }
 \item{\code{encode()}}{
   Encodes a ISOMetadata* R6 object to XML representation
 }
 \item{\code{wrapBaseElement(field, fieldObj)}}{
   Wraps a base element type
 }
 \item{\code{contains(field, metadataElement)}}{
   Indicates of the present class object contains an metadata element object
   for a particular list-based field.
 }
 \item{\code{addListElement(field, metadataElement)}}{
   Adds a metadata element to a list-based field. Returns TRUE if the element
   has been added, FALSE otherwise. In case an element is already added, the
   element will not be added and this method will return FALSE.
 }
 \item{\code{delListElement(field, metadataElement)}}{
   Deletes a metadata element from a list-based field. Returns TRUE if the element
   has been deleted, FALSE otherwise. In case an element is abstent, this method
   will return FALSE.
 }
}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{element}
\keyword{metadata}

