% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lewis.R
\name{get_lewis}
\alias{get_lewis}
\title{Get historical United States Congressional District Shapefiles}
\usage{
get_lewis(state, congress)
}
\arguments{
\item{state}{two letter state abbreviation}

\item{congress}{congress number, from 1 to 114.}
}
\value{
a sf tibble of the congressional district boundaries
}
\description{
Data sourced from the United States Congressional District Shapefiles, primarily
hosted at \url{https://cdmaps.polisci.ucla.edu/}. Files are fetched through the GitHub
repository at \url{https://github.com/JeffreyBLewis/congressional-district-boundaries}.
}
\examples{
get_lewis(state = 'NM', congress = 111)
}
\references{
Jeffrey B. Lewis, Brandon DeVine, Lincoln Pitcher, and Kenneth C. Martis. (2013)
Digital Boundary Definitions of United States Congressional Districts, 1789-2012.
[Data file and code book]. Retrieved from \url{https://cdmaps.polisci.ucla.edu} on [date of download].
}
