% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatables.R
\name{create_tract_table}
\alias{create_tract_table}
\title{Create Tract Level Data}
\usage{
create_tract_table(
  state,
  county,
  geometry = TRUE,
  year = 2019,
  mem = FALSE,
  epsg = 3857,
  geography
)
}
\arguments{
\item{state}{Required. Two letter state postal code.}

\item{county}{Optional. Name of county.  If not provided, returns tracts for the entire state.}

\item{geometry}{Defaults to TRUE. Whether to return the geography or not.}

\item{year}{year, must be >= 2009 and <= 2019.}

\item{mem}{Default is FALSE. Set TRUE to use memoized backend.}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}

\item{geography}{Deprecated. Use geometry.}
}
\value{
dataframe with data for each tract in the selected region. Data includes
3 sets of columns for each race or ethnicity category: population (pop), voting age
population (vap), and citizen voting age population (cvap)
}
\description{
Create Tract Level Data
}
\examples{
\dontrun{
# Relies on Census Bureau API
tract <- create_tract_table('NY', 'Rockland', year = 2018)
}
}
\concept{datatable}
