% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_population_grid.R
\name{get_population_grid}
\alias{get_population_grid}
\title{Get Finnish Statistics grid in two different resolutions for years 2010-2019}
\usage{
get_population_grid(year = 2017, resolution = 5)
}
\arguments{
\item{year}{A numeric for year of the population grid. Years available 2010-2019.}

\item{resolution}{1 (1km x 1km) or 5 (5km x 5km)}
}
\value{
sf object
}
\description{
Thin wrapper around Finnish zip code areas provided by
\href{https://www.tilastokeskus.fi/tup/karttaaineistot/postinumeroalueet.html}{Statistic Finland}.
}
\examples{
 \dontrun{
 f <- get_population_grid(year=2017)
 plot(f)
 }

}
\author{
Markus Kainu \href{mailto:markus.kainu@kela.fi}{markus.kainu@kela.fi}, Joona Lehtomäki \href{mailto:joona.lehtomaki@iki.fi}{joona.lehtomaki@iki.fi}
}
