% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{Geolocaliza endereços no Brasil}
\usage{
geocode(
  enderecos,
  campos_endereco = definir_campos(),
  resultado_completo = FALSE,
  resolver_empates = TRUE,
  resultado_sf = FALSE,
  h3_res = NULL,
  padronizar_enderecos = TRUE,
  verboso = TRUE,
  cache = TRUE,
  n_cores = NULL
)
}
\arguments{
\item{enderecos}{Um \code{data.frame}. Os endereços a serem geolocalizados. Cada
coluna deve representar um campo do endereço.}

\item{campos_endereco}{Um vetor de caracteres. A correspondência entre cada
campo de endereço e o nome da coluna que o descreve na tabela \code{enderecos}.
A função \code{\link[=definir_campos]{definir_campos()}} auxilia na criação deste vetor e realiza
algumas verificações nos dados de entrada. Campos de endereço passados
como \code{NULL} serão ignorados, e a função deve receber pelo menos um campo
não nulo, além  dos campos \code{"estado"} e \code{"municipio"}, que são
obrigatórios. Note que o campo  \code{"localidade"} é equivalente a 'bairro'.}

\item{resultado_completo}{Lógico. Indica se o output deve incluir colunas
adicionais, como o endereço encontrado de referência. Por padrão, é \code{FALSE}.}

\item{resolver_empates}{Lógico. Alguns resultados da geolocalização podem
indicar diferentes coordenadas possíveis (e.g. duas ruas diferentes com o
mesmo nome em uma mesma cidade). Esses casos são trados como 'empate' e o
parâmetro \code{resolver_empates} indica se a função deve resolver esses empates
automaticamente. Por padrão, é \code{TRUE}, e a função retorna apenas o caso
mais provável. Para mais detalhes sobre como é feito o processo de
desempate, consulte abaixo a seção "Detalhes".}

\item{resultado_sf}{Lógico. Indica se o resultado deve ser um objeto espacial
da classe \code{sf}. Por padrão, é \code{FALSE}, e o resultado é um \code{data.frame} com
as colunas \code{lat} e \code{lon}.}

\item{h3_res}{Um número que indica a resolução espacial da célula hexagonal
H3 da localização dos pontos retornados. Também aceita um vetor de números,
e.g. \code{c(8, 9)} Por padrão, é \code{NULL}. Detalhes sobre as resoluções disponíveis
em \url{https://h3geo.org/docs/core-library/restable/}}

\item{padronizar_enderecos}{Lógico. Indica se os dados de endereço de entrada
devem ser padronizados. Por padrão, é \code{TRUE}. Essa padronização é essencial
para uma geolocalizaçao correta. Alerta! Apenas utilize
\code{padronizar_enderecos = FALSE} caso os dados de input já tenham sido
padronizados anteriormente com \code{enderecobr::padronizar_enderecos(..., formato_estados = 'sigla', formato_numeros = 'integer')}.}

\item{verboso}{Um valor lógico. Indica se barras de progresso e mensagens
devem ser exibidas durante o download dos dados do CNEFE e a geocodificação
dos endereços. O padrão é \code{TRUE}.}

\item{cache}{Um valor lógico. Indica se os dados do CNEFE devem ser salvos ou
lidos do cache, reduzindo o tempo de processamento em chamadas futuras. O
padrão é \code{TRUE}. Quando \code{FALSE}, os dados do CNEFE são baixados para um
diretório temporário.}

\item{n_cores}{Um número. O número de núcleos de CPU a serem utilizados no
processamento dos dados. Por padrão, \code{n_cores = NULL} e o pacote utiliza o
número máximo de cores físicos disponíveis.}
}
\value{
Retorna o \code{data.frame} de input \code{enderecos} adicionado das colunas de
latitude (\code{lat}) e longitude (\code{lon}), bem como as colunas (\code{precisao} e
\code{tipo_resultado}) que indicam o nível de precisão e o tipo de resultado.
Alternativamente, o resultado pode ser um objeto \code{sf}.
}
\description{
Geocodifica endereços brasileiros com base nos dados do CNEFE. Os endereços
de input devem ser passados como um \code{data.frame}, no qual cada coluna
descreve um campo do endereço (logradouro, número, cep, etc). Os resuldos dos
endereços geolocalizados podem seguir diferentes níveis de precisão. Consulte
abaixo a seção "Detalhes" para mais informações. As coordenadas de output
utilizam o sistema de coordenadas geográficas SIRGAS 2000, EPSG 4674.
}
\details{
Precisão dos resultados:

A precisão dos resultados do \strong{{geocodebr}} são apresentadas em 3 colunas,
\code{precisao}, \code{tipo_resultado} e \code{desvio_metros}, explicadas abaixo.

Lidando com casos de empate:

No processo de geolocalização de dados, é possível que para alguns endereços
de input sejam encontrados diferentes coordenadas possíveis (e.g. duas ruas
diferentes com o mesmo nome, mas em bairros distintos em uma mesma cidade).
Esses casos são trados como empate'. Quando a função \code{geocode()} recebe o
o parâmetro \code{resolver_empates = TRUE}, os casos de empate são resolvidos
automaticamente pela função. A solução destes empates é feita da seguinte
maneira:
\enumerate{
\item Quando se encontra diferente coordenadas possíveis para um mesmo endereço
de input, nós assumimos que essas coordendas pertencem provavelmente a endereços
diferentes se (a) estas coordenadas estão a mais de 1Km entre si, ou (b) estão
associadas a um logradouro 'ambíguo', i.e. que costumam se repetir em muitos
bairros (e.g. "RUA A", "RUA QUATRO", "RUA 10", etc). Nestes casos, a solução
de desempate é retornar o ponto com maior número de estabelecimentos no CNEFE,
valor indicado na coluna \code{"contagem_cnefe"}.
\item Quando as coordenadas possivelmente associadas a um endereço estão a menos
de 1Km entre si e não se trata de um logradouro 'ambíguo', nós assumimos que
os pontos pertencem provavelmente ao mesmo logradouro (e.g. diferentes CEPs
ao longo de uma mesma rua). Nestes casos, a solução de desempate é retornar
um ponto que resulta da média das coordenadas dos pontos possíveis ponderada
pelo valor de \code{"contagem_cnefe"}. Nesse caso, a coluna de output
\code{"endereco_encontrado"} recebe valor do ponto com maior \code{"contagem_cnefe"}.
}
}
\section{Precisão}{
Os resultados são classificados em seis amplas categorias de \code{precisao}:
\enumerate{
\item "numero"
\item "numero_aproximado"
\item "logradouro"
\item "cep"
\item "localidade"
\item "municipio"
}

Cada nível de precisão pode ser desagregado em tipos de resultado mais
refinados.
}

\section{Tipos de resultados}{
A coluna \code{tipo_resultado} fornece informações mais detalhadas sobre como
exatamente cada endereço de entrada foi encontrado no CNEFE. Em cada
categoria,  o \strong{{geocodebr}} calcula a média da latitude e longitude dos
endereços incluídos no CNEFE que correspondem ao endereço de entrada, com
base em combinações de diferentes campos. No caso mais rigoroso, por exemplo,
a função encontra uma correspondência determinística para todos os campos de
um dado endereço (\code{"estado"}, \code{"municipio"}, \code{"logradouro"}, \code{"numero"},
\code{"cep"}, \code{"localidade"}). Pense, por exemplo, em um prédio com vários
apartamentos que correspondem ao mesmo endereço de rua e número. Nesse caso,
as coordenadas dos apartamentos podem diferir ligeiramente, e o
\strong{{geocodebr}} calcula a média dessas coordenadas. Em um caso menos rigoroso,
no qual apenas os campos (\code{"estado"}, \code{"municipio"}, \code{"logradouro"},
\code{"localidade"}) são encontrados, o \strong{{geocodebr}} calcula as coordenadas
médias de todos os endereços no CNEFE ao longo daquela rua e que se encontram
na mesma localidade/bairro. Assim, as coordenadas de resultado tendem a ser o
ponto médio do trecho daquela rua que passa dentro daquela localidade/bairro.

A coluna \code{tipo_resultado} fornece informações mais detalhadas sobre os campos de
endereço utilizados no cálculo das coordenadas de cada endereço de entrada. Cada
categoria é nomeada a partir de um código de quatro caracteres:
\itemize{
\item o primeiro caracter, sempre \code{d} ou \code{p}, determina se a correspondência foi
feita de forma determinística (\code{d}) ou probabilística (\code{p});
\item o segundo faz menção à categoria de \code{precisao} na qual o resultado foi
classificado (\code{n} para \code{"numero"}, \code{a} para \code{"numero_aproximado"}, \code{r} para
\code{"logradouro"}, \code{c} para \code{"cep"}, \code{b} para \code{"localidade"} e \code{m} para \code{"municipio"});
\item o terceiro e o quarto caracteres designam a classificação de cada categoria
dentro de seu grupo - via de regra, quanto menor o número formado por esses
caracteres, mais precisa são as coordenadas calculadas.
}

As categorias de \code{tipo_resultado} são listadas abaixo, junto às categorias de
\code{precisao} a qual elas estão associadas:
\itemize{
\item precisao \code{"numero"}
\itemize{
\item \code{dn01} - logradouro, numero, cep e localidade
\item \code{dn02} - logradouro, numero e cep
\item \code{dn03} - logradouro, numero e localidade
\item \code{dn04} - logradouro e numero
\item \code{pn01} - logradouro, numero, cep e localidade
\item \code{pn02} - logradouro, numero e cep
\item \code{pn03} - logradouro, numero e localidade
\item \code{pn04} - logradouro e numero
}
\item precisao \code{"numero_aproximado"}
\itemize{
\item \code{da01} - logradouro, numero, cep e localidade
\item \code{da02} - logradouro, numero e cep
\item \code{da03} - logradouro, numero e localidade
\item \code{da04} - logradouro e numero
\item \code{pa01} - logradouro, numero, cep e localidade
\item \code{pa02} - logradouro, numero e cep
\item \code{pa03} - logradouro, numero e localidade
\item \code{pa04} - logradouro e numero
}
\item precisao \code{"logradouro"} (quando o número de entrada está faltando 'S/N')
\itemize{
\item \code{dl01} - logradouro, cep e localidade
\item \code{dl02} - logradouro e cep
\item \code{dl03} - logradouro e localidade
\item \code{dl04} - logradouro
\item \code{pl01} - logradouro, cep e localidade
\item \code{pl02} - logradouro e cep
\item \code{pl03} - logradouro e localidade
\item \code{pl04} - logradouro
}
\item precisao \code{"cep"}
\itemize{
\item \code{dc01} - municipio, cep, localidade
\item \code{dc02} - municipio, cep
}
\item precisao \code{"localidade"}
\itemize{
\item \code{db01} - municipio, localidade
}
\item precisao \code{"municipio"}
\itemize{
\item \code{dm01} - municipio
}
}

Endereços não encontrados são retornados com latitude, longitude, precisão e
tipo de resultado \code{NA}.
}

\section{Desvio em metros}{
A coluna \code{desvio_metros} apresenta uma forma intuitiva e prática de saber o
grau de incerteza do resultado encontrado. Essa coluna informa que pelo menos
95\% de todos os pontos do CNEFE que possuem corrêspondência com o endereço de
input estão num raio de \code{x} metros da localização encontrada.

Um desvio de até \code{30} metros, por exemplo, tende a representar um resultado
muito confiável. A depender de como o dado geolocalizado será utilizado, até
mesmos resultados com \code{desvio_metros} de até 500 ou 900 metros podem ser ser
aceitáveis.

A coluna \code{desvio_metros} é particularmente útil para decidir por exemplo se
um resultado encontrado com a \code{precisao} de CEP, localidade ou logradouro
deveria ser aceitável. Por exemplo, muitas cidades do Brasil possuem um CEP
único, o que tende a gerar resultados com alto grau de incerteza. Em várias
cidades, no entanto, um CEP pode ser circunscrito a uma área muito pequena e
as vezes até um único edifício. Nesses casos, o valor do \code{desvio_metros}
tende a ser bem pequeno.
}

\section{Busca probabilistica}{
Os tipos de resultado com busca probabilitisca usam como base o algoritmo de
semelhança de Jaro para comparar as strings de 'logradouro' dos dados de
input e da base de endereços do geocodebr. O pacote considera como match o
logradouro da base de endereços que apresenta a maior semelhança de Jaro
condicionado a uma semelhança mínima, e desde que também haja match
determinístico em ao menos um dos campos "cep" e "localidade".
O geocodebr utiliza uma semelhança mínima de \code{0.85} nos casos de match
probabilistico, e de \code{0.90} nos demais casos.
}

\section{Código do setor censitário}{
Quando o usuário passa o argumento \code{resultado_completo = TRUE}, a função
\code{geocode()} também retorna a coluna \code{cod_setor} com o código do setor
censitário do endereço encontrado. Atualmente, a função somente retorna o
código do setor dos casos em todos os pontos do CNEFE correspondentes estão
100\% dentro de um único setor censitário. Quanto os dados do CNEFE
correspondentes ao endereço buscado estão em mais de um setor, o resultado da
coluna \code{cod_setor} é \code{NA}.
}

\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) withAutoprint(\{ # examplesIf}
library(geocodebr)

# ler amostra de dados
data_path <- system.file("extdata/small_sample.csv", package = "geocodebr")
input_df <- read.csv(data_path)[1:2,]

fields <- geocodebr::definir_campos(
  logradouro = "nm_logradouro",
  numero = "Numero",
  cep = "Cep",
  localidade = "Bairro",
  municipio = "nm_municipio",
  estado = "nm_uf"
)

df <- geocodebr::geocode(
  enderecos = input_df,
  campos_endereco = fields,
  resolver_empates = TRUE
  )

head(df)
\dontshow{\}) # examplesIf}
}
