% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_ppp.R
\name{smooth_ppp}
\alias{smooth_ppp}
\title{Smooth outcome events}
\usage{
smooth_ppp(data, method, sampling = NA)
}
\arguments{
\item{data}{the name of a hyperframe and column of interest.
`data` should be in the form of `"hyperframe$column"`.}

\item{method}{methods for smoothing ppp objects.
Either `"mclust"` or `"abramson"`. See details.}

\item{sampling}{numeric between 0 and 1. `sampling` determines the proportion of data
to use for initialization. By default, NA (meaning that it uses all data without sampling).}
}
\value{
im objects
}
\description{
`smooth_ppp()` takes a column of hyperframes (ppp objects) and smoothes them.
}
\details{
To smooth ppp objects, users can choose either the Gaussian mixture model (`method = "mclust"`)
or Abramson's adaptive smoothing (`method = "abramson"`).
The Gaussian mixture model is essentially the method that performs model-based clustering of all the observed points.
In this package, we employ the EII model (equal volume, round shape (spherical covariance)).
This means that we model observed points by several Gaussian densities with the same, round shape.
This is why this model is called fixed-bandwidth smoothing. This is a simple model to smooth observed points,
yet given that analyzing spatiotemporal data is often computationally demanding, it is often the best place to start (and end).
Sometimes this process can also take time, which is why an option for `init` is included in this function.

Another, more precise, method for smoothing outcomes is adaptive smoothing (`method = "abram"`).
This method allows users to vary bandwidths based on `Abramson (1982)`.
Essentially, this model assumes that the bandwidth is inversely proportional to the square root of the target densities.
Since the bandwidth is adaptive, the estimation is usually more precise than the Gaussian mixture model.
However, the caveat is that this method is often extremely computationally demanding.
}
\examples{
# Time variable
dat_out <- insurgencies[1:100, ]
dat_out$time <- as.numeric(dat_out$date - min(dat_out$date) + 1)

# Hyperframe
dat_hfr <- get_hfr(data = dat_out,
                   col = "type",
                   window = iraq_window,
                   time_col = "time",
                   time_range = c(1, max(dat_out$time)),
                   coordinates = c("longitude", "latitude"),
                   combine = TRUE)

# Smoothing outcome
smooth_ppp(data = dat_hfr$all_combined,
           method = "mclust",
           sampling = 0.05)
}
