% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dist_based_exp.R
\name{get_dist_based_exp}
\alias{get_dist_based_exp}
\title{Get the expectation of treatment events with arbitrary distances}
\usage{
get_dist_based_exp(
  cf_sim_results,
  entire_window,
  dist_map,
  dist_map_unit = "km",
  grayscale = FALSE,
  use_raw = FALSE
)
}
\arguments{
\item{cf_sim_results}{output of `sim_cf_dens()`}

\item{entire_window}{owin object of the entire region}

\item{dist_map}{im object whose cell values are the distance from a focus (e.g., city)}

\item{dist_map_unit}{either `"km"` or `"mile"`}

\item{grayscale}{logical. `grayscale` specifies whether to convert plot to grayscale (by default, FALSE).}

\item{use_raw}{logical. `use_raw` specifies whether to use the raw value of expectations or percentiles.
By default, `FALSE`.}
}
\value{
ggplot object that summarizes how expectations change over distances from a focus
}
\description{
`get_dist_based_exp()` takes counterfactual densities and
and returns the expected number of treatment events based on distances
from a user-specified focus.
}
