% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.gensvm.R
\name{coef.gensvm}
\alias{coef.gensvm}
\title{Get the coefficients of the fitted GenSVM model}
\usage{
\method{coef}{gensvm}(object, ...)
}
\arguments{
\item{object}{a \code{gensvm} object}

\item{\dots}{further arguments are ignored}
}
\value{
The coefficients of the GenSVM model. This is a matrix of size
\eqn{(n_{features} + 1) x (n_{classes} - 1)}. This matrix is used to project 
the input data to a low dimensional space using the equation: \eqn{XW + t} 
where \eqn{X} is the input matrix, \eqn{t} is the first row of the matrix 
returned by this function, and \eqn{W} is the \eqn{n_{features} x 
(n_{classes} - 1)} matrix formed by the remaining rows.
}
\description{
Returns the model coefficients of the GenSVM object
}
\examples{
x <- iris[, -5]
y <- iris[, 5]

fit <- gensvm(x, y)
V <- coef(fit)

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{http://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm}}, \code{\link{plot.gensvm}}, 
\code{\link{predict.gensvm}}, \code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
