% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pls.treemodel}
\alias{pls.treemodel}
\title{PLS-PM results of terminal nodes from the Pathmox Segmentation Trees}
\usage{
pls.treemodel(xpls, xtree, X = NULL, alpha = 0.05, terminal = TRUE,
  scaled = FALSE, label = FALSE, label.nodes = NULL, ...)
}
\arguments{
\item{xpls}{An object of class \code{"plspm"} returned by \code{\link{plspm}}.}

\item{xtree}{An object of class \code{"xtree.pls"} returned by
\code{\link{pls.pathmox}}.}

\item{X}{Optional dataset (matrix or data frame) used when argument
\code{dataset=NULL} inside \code{xpls}.}

\item{alpha}{is numeric value indicating the significance threshold of the invariance test}

\item{terminal}{is string, if equal to \code{TRUE}, just the terminal nodes are considered
for the output reults. when it is equal to \code{FALSE},the PLS-PM results are generated
for all nodes of the tree}

\item{scaled}{to standardize the latent variables or not}

\item{label}{is a string. It is false for defect. If it is \code{TRUE}, label.nodes has to be fix.}

\item{label.nodes}{is a vector with the name of the nodes. It is null for defect.}

\item{\dots}{Further arguments passed on to \code{\link{pls.treemodel}}.}
}
\value{
An object of class \code{"treemodel.pls"}. Basically a list with the
following results:

\item{inner}{Matrix of the inner relationship between latent variables of the PLS-PM model}

\item{invariance.test}{A data frame containing the results of the invariance test}

\item{weights}{Matrix of outer weights for each terminal node}

\item{loadings}{Matrix of loadings for each terminal node}

\item{paths}{Matrix of path coefficients for each terminal node}

\item{r2}{Matrix of r-squared coefficients for each terminal node}

\item{sign}{list of matrix with the significance for each terminal node}
}
\description{
Calculates basic PLS-PM results for the terminal nodes of PATHMOX
trees
}
\details{
The argument \code{xpls} must be the same used for calculating the
\code{xtree} object.  When the object \code{xpls} does not contain a data
matrix (i.e. \code{pls$data=NULL}), the user must provide the data matrix or
data frame in \code{X}.

The argument \code{xtree} is an object of class \code{"xtree.pls"} returned by
\code{\link{pls.pathmox}}.
}
\examples{
\dontrun{
 ## example of PLS-PM in alumni satisfaction

 data(fibtele)

 # select manifest variables
 data.fib <-fibtele[,12:35]

 # define inner model matrix
 Image 			= rep(0,5)
	 Qual.spec		= rep(0,5)
	 Qual.gen			= rep(0,5)
	 Value			= c(1,1,1,0,0)
	 Satis			= c(1,1,1,1,0)
 inner.fib <- rbind(Image,Qual.spec, Qual.gen, Value, Satis)
 colnames(inner.fib) <- rownames(inner.fib)

 # blocks of indicators (outer model)
 outer.fib <- list(1:8,9:11,12:16,17:20,21:24)
 modes.fib  = rep("A", 5)

 # apply plspm
 pls.fib <- plspm(data.fib, inner.fib, outer.fib, modes.fib)


 # re-ordering those segmentation variables with ordinal scale
  seg.fib= fibtele[,2:11]

	 seg.fib$Age = factor(seg.fib$Age, ordered=T)
	 seg.fib$Salary = factor(seg.fib$Salary,
			levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
	 seg.fib$Accgrade = factor(seg.fib$Accgrade,
			levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
	 seg.fib$Grade = factor(seg.fib$Grade,
			levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

 # Pathmox Analysis
 fib.pathmox=pls.pathmox(pls.fib,seg.fib,signif=0.05,
					deep=2,size=0.2,n.node=20)

 fib.comp=pls.treemodel(pls.fib,fib.pathmox)

 }
}
\author{
Giuseppe Lamberti
}
\references{
Sanchez, G. (2009) \emph{PATHMOX Approach: Segmentation Trees in
Partial Least Squares Path Modeling.} PhD Dissertation.

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}
\seealso{
\code{\link{pls.pathmox}},\code{\link{plot.xtree.pls}}
}

