% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_genlogis.R
\name{distrib}
\alias{distrib}
\alias{pgenlog}
\alias{dgenlog}
\alias{qgenlog}
\alias{rgenlog}
\title{The Generalized logistic distribution}
\usage{
pgenlog(q, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0)

dgenlog(x, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0)

qgenlog(k, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0)

rgenlog(n, a = sqrt(2/pi), b = 0.5, p = 2, mu = 0)
}
\arguments{
\item{a, b, p}{parameters >= 0, with restrictions.*}

\item{mu}{mu parameter}

\item{x, q}{vector of quantiles.}

\item{k}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required}
}
\value{
\code{dgenlog} gives the density, \code{pgenlog} gives the distribution function, 
\code{qgenlog} gives the quantile function, and \code{rgenlog} generates random deviates.\cr
 
 The length of the result is determined by \code{n} for \code{rgenlog}, and is the maximum of the lengths 
 of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function and random generation a generalized logistic distribution.
}
\details{
The used distribution for this package is given by: \deqn{f(x) = ((a + b*(1+p)*(abs(x-mu)^p))*exp(-(x-mu)*(a+b*(|x-mu|^p)))) / ((exp(-(x-mu)*(a + b* (|x-mu|^p)))+1)^2)}
 
The \code{qgenlog()} returns values for P(X < x).\cr 

The default values for \code{a, b, p and mu} produces a function with mean 0 and variance close to 1.\cr 

*Restrictions:\cr 

If \code{p} equals to 0, \code{b} or \code{a} must be 0 otherwise there is identifiability problem.\cr 

The distribution is not defined for \code{a} and \code{b} equal to 0 simultaneously.\cr
}
\examples{
pgenlog(0.5) 
curve(dgenlog(x), xlim = c(-3,3)) 

rgenlog(100) 

qgenlog(0.95)

}
\references{
Rathie, P. N. and Swamee, P. K (2006) \emph{On a new invertible generalized logistic distribution
approximation to normal distribution}, Technical Research Report in Statistics, 07/2006,
Dept. of Statistics, Univ. of Brasilia, Brasilia, Brazil.
}
\keyword{genlogis}
