% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_genius.R
\name{add_genius}
\alias{add_genius}
\title{Add lyrics to a data frame}
\usage{
add_genius(data, artist, title, type = "album")
}
\arguments{
\item{data}{This is a dataframe with one column for the artist name, and the other column being either the track title or the album title.}

\item{artist}{This is the column which has artist title information}

\item{title}{This is the column that has either album titles, track titles, or both.}

\item{type}{This is a single value character string of either "album" or "lyrics". This tells the function what kind of lyrics to pull. Alternatively, this can be a column with the value of "album" or "lyrics" associated with each row.}
}
\description{
This function is to be used to build on a data frame with artist and album/track information. Ideal via the spotifyr package.
}
\examples{
\donttest{
artist_albums <- tribble(
 ~artist, ~album,
 "J. Cole", "KOD",
 "Sampha", "Process"
)


artist_albums \%>\%
 add_genius(artist, album)

artist_songs <- tribble(
 ~artist, ~track,
 "J. Cole", "Motiv8",
 "Andrew Bird", "Anonanimal"
)

artist_songs \%>\%
 add_genius(artist, track, type = "lyrics")
}

}
