% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_files_grm.R
\name{delete_files_grm}
\alias{delete_files_grm}
\title{Delete all GCTA binary GRM files}
\usage{
delete_files_grm(file)
}
\arguments{
\item{file}{The shared file path (excluding extensions: \code{grm.bin}, \code{grm.N.bin}, or \code{grm.id}).}
}
\value{
Nothing
}
\description{
This function deletes each of the GCTA binary GRM files (\code{grm.bin}, \code{grm.N.bin}, and \code{grm.id} extensions) given the shared base file path, warning if any of the files did not exist or if any were not successfully deleted.
}
\examples{
# if you want to delete "data.grm.bin", "data.grm.N.bin" and "data.grm.id", run like this:
# delete_files_grm("data")

# The following example is more awkward
# because (only for these examples) the package must create *temporary* files to actually delete

# create dummy GRM files
file <- tempfile('delete-me-test') # no extension
# add each extension and create empty files
file.create( paste0(file, '.grm.bin') )
file.create( paste0(file, '.grm.N.bin') )
file.create( paste0(file, '.grm.id') )

# delete the GRM files we just created
delete_files_grm(file)

}
