% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genderize.R
\name{genderize}
\alias{genderize}
\title{Predicting gender for character strings.}
\usage{
genderize(x, genderDB, blacklist = NULL, progress = TRUE)
}
\arguments{
\item{x}{A vector of text strings.}

\item{genderDB}{A data.table output of  \code{findGivenNames} function 
for the vector x.}

\item{blacklist}{Some terms could be excluded from gender checking}

\item{progress}{If TRUE (default) progress bar is displayed in the console}
}
\value{
A data table with text string, a term found in \code{genderDB},
 that is finally used as a given name to predict gender, 
 a predicted gender, number of potential gender indicators 
("1" if only one term from the text string is found in \code{genderDB}).
}
\description{
For each character string in \code{x} vector \code{genderize} 
use output of the 
\code{findGivenNames} function and returns 
a gender prediction for the whole character string based 
on possible first name terms located inside those strings.
}
\examples{
\dontrun{

x = c("Winston J. Durant, ASHP past president, dies at 84", 
"Gold Badge of Honour of the DGAI Prof. Dr. med. Norbert R. Roewer Wuerzburg",
"The contribution of professor Yu.S. Martynov (1921-2008) to Russian neurology", 
"JAN BASZKIEWICZ (3 JANUARY 1930 - 27 JANUARY 2011) IN MEMORIAM", 
"Maria Sklodowska-Curie")

givenNames = findGivenNames(x)
givenNames = givenNames[count>40]
genderize(x, genderDB=givenNames, blacklist=NULL)

#                                                                             text
# 1:                            Winston J. Durant, ASHP past president, dies at 84
# 2:   Gold Badge of Honour of the DGAI Prof. Dr. med. Norbert R. Roewer Wuerzburg
# 3: The contribution of professor Yu.S. Martynov (1921-2008) to Russian neurology
# 4:                JAN BASZKIEWICZ (3 JANUARY 1930 - 27 JANUARY 2011) IN MEMORIAM
# 5:                                                        Maria Sklodowska-Curie

#    givenName gender genderIndicators
# 1:   winston   male                1
# 2:       med   male                2
# 3:        NA     NA                0
# 4:       jan   male                1
# 5:     maria female                1

}

}

