/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.MCMCSettings;

public final class YadasSettings
extends AbstractObservable
implements MCMCSettings {
    private int d_simulationIterations;
    private int d_tuningIterations;
    private final int d_thinning;
    private final int d_numberOfChains;
    private final double d_varianceScalingFactor;

    public YadasSettings(int tuningIterations, int simulationIterations, int thinning, int numberOfChains, double varianceScalingFactor) {
        this.d_simulationIterations = simulationIterations;
        this.d_tuningIterations = tuningIterations;
        this.d_thinning = thinning;
        this.d_numberOfChains = numberOfChains;
        this.d_varianceScalingFactor = varianceScalingFactor;
    }

    public YadasSettings(MCMCSettings settings) {
        this(settings.getTuningIterations(), settings.getSimulationIterations(), settings.getThinningInterval(), settings.getNumberOfChains(), settings.getVarianceScalingFactor());
    }

    public double getVarianceScalingFactor() {
        return this.d_varianceScalingFactor;
    }

    public int getTuningIterations() {
        return this.d_tuningIterations;
    }

    public void setTuningIterations(int newValue) {
        int oldValue = this.d_tuningIterations;
        this.d_tuningIterations = newValue;
        this.firePropertyChange("tuningIterations", oldValue, newValue);
    }

    public int getThinningInterval() {
        return this.d_thinning;
    }

    public int getSimulationIterations() {
        return this.d_simulationIterations;
    }

    public void setSimulationIterations(int newValue) {
        int oldValue = this.d_simulationIterations;
        int oldInferenceSamples = this.getInferenceSamples();
        this.d_simulationIterations = newValue;
        this.firePropertyChange("simulationIterations", oldValue, newValue);
        this.firePropertyChange("inferenceSamples", oldInferenceSamples, this.getInferenceSamples());
    }

    public int getNumberOfChains() {
        return this.d_numberOfChains;
    }

    public int getInferenceSamples() {
        return this.d_simulationIterations / (2 * this.d_thinning) * this.d_numberOfChains;
    }
}

