% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_garden.R
\name{gemini_garden}
\alias{gemini_garden}
\title{Interact with Vertex AI Model Garden}
\usage{
gemini_garden(token, project_id, pdf_path)
}
\arguments{
\item{token}{Token object (e.g., from \code{token.vertex()}) containing the access token, region, and model_id.}

\item{project_id}{Google Cloud project ID.}

\item{pdf_path}{Path to the PDF file to be processed.}
}
\value{
A parsed list containing the results from the Vertex AI API (e.g., OCR results).
}
\description{
This function sends a PDF file to the Vertex AI Model Garden (Mistral model) for processing, such as OCR. The PDF is encoded as base64 and sent to the rawPredict endpoint. The function is designed for future extension to support other document types and tasks.
}
\details{
The PDF file is read and encoded as base64, then sent to the Vertex AI rawPredict endpoint for processing using a Mistral model. This function is structured for future extension to support other document types and model tasks available in Vertex AI Model Garden.

For more information about available models, endpoints, and supported tasks, see \href{https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/explore-models}{Vertex AI Model Garden documentation}.
}
\examples{
\dontrun{
# Issue a token using token.vertex() first
my_token <- token.vertex(
  jsonkey = "your-service-account.json",
  region = "us-central1",
  model_id = "mistral-ocr-2505"
)
result <- gemini_garden(
  token = my_token,
  project_id = "your-project-id",
  pdf_path = "sample.pdf"
)
print(result)
}

}
\seealso{
\url{https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/explore-models}
}
