% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{methods}
\name{get_corrections}
\alias{get_corrections}
\alias{get_corrections,geex-method}
\alias{get_corrections,m_estimation_basis,m_estimation_basis-method}
\title{Gets the corrections from a geex object}
\usage{
get_corrections(object, ...)

\S4method{get_corrections}{geex}(object)
}
\arguments{
\item{object}{a \code{\linkS4class{geex}} object}

\item{...}{arguments passed to other methods}
}
\description{
Gets the corrections from a geex object
}
\examples{
myee <- function(data){
 function(theta){
   c(data$Y1 - theta[1],
   (data$Y1 - theta[1])^2 - theta[2])
  }
}

results <- m_estimate(
   estFUN = myee,
   data = geexex,
   root_control = setup_root_control(start = c(1,1)),
   corrections  = list(
     bias_correction_.1 = correction(fay_bias_correction, b = .1),
     bias_correction_.3 = correction(fay_bias_correction, b = .3))
   )

get_corrections(results)
}
