% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{methods}
\name{coef,geex-method}
\alias{coef,geex-method}
\alias{coef,geex,geex-method}
\alias{coef,geex_summary-method}
\title{Gets the parameter estimates from a geex object}
\usage{
\S4method{coef}{geex}(object)

\S4method{coef}{geex_summary}(object)
}
\arguments{
\item{object}{a \code{\linkS4class{geex}} object}
}
\description{
Gets the parameter estimates from a geex object
}
\examples{
ex_eeFUN <- function(data){
 function(theta){
   with(data,
    c(Y1 - theta[1],
     (Y1 - theta[1])^2 - theta[2] ))
}}

results <- m_estimate(
 estFUN = ex_eeFUN,
 data  = geexex,
 root_control = setup_root_control(start = c(1,1)))

coef(results)
}
