% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getGEER}
\alias{getGEER}
\alias{getGEER.geerMod}
\title{Extract or Get Generalized Components from a Fitted GEE-MCD/WGEE-MCD
  Model}
\usage{
getGEER(object, name, sub.num)

\method{getGEER}{geerMod}(object, name = c("m", "Y", "X", "Z", "W", "H", "D",
  "T", "Sigma", "mu", "theta", "beta", "lambda", "gamma", "alpha", "sd", "FIM",
  "quasilik", "BIC", "iter", "triple", "pij", "cpij"), sub.num = 0)
}
\arguments{
\item{object}{a fitted joint mean covariance model of class "geerMod", i.e.,
typically the result of geer().}

\item{name}{a character vector specifying the name(s) of the "component".

When sub.num is not specified or equal to 0, possible values are:
\describe{
  \item{\code{"m"}}{a vector of number of measurement for each subject}
  \item{\code{"Y"}}{response vector}
  \item{\code{"X"}}{model matrix for mean structure}
  \item{\code{"Z"}}{model matrix for covariance structure (the diagonal
  matrix)}
  \item{\code{"W"}}{model matrix for covariance structure (the lower triangular
  matrix)}
  \item{\code{"H"}}{a vector of weights used in WGEE-MCD}
  \item{\code{"FIM"}}{Fisher Information matrix}
  \item{\code{"theta"}}{parameter estimates of GEE-MCD/WGEE-MCD model}
  \item{\code{"sd"}}{standard deviations for parameter estimates of
  GEE-MCD/WGEE-MCD model}
  \item{\code{"beta"}}{parameter estimates for mean structure model}
  \item{\code{"lambda"}}{parameter estimates for covariace structure (the
  diagonal matrix)}
  \item{\code{"gamma"}}{parameter estimates for covariance structure (the lower
  triangular matrix)}
  \item{\code{"quasilik"}}{quasi-likelihood}
  \item{\code{"QIC"}}{Quasi information criterion}
  \item{\code{"iter"}}{number of iterations until convergence}
  \item{\code{"triple"}}{(p, d, q)}
  \item{\code{"pij"}}{a vector of remaining probability}
  \item{\code{"cpij"}}{a vector of cumulative remaining probability}
}

When sub.num is specified, possible values are:
\describe{
  \item{\code{"m"}}{number of measurements for subject i}
  \item{\code{"Y"}}{response vector for subject i}
  \item{\code{"X"}}{model matrix of subject i for mean structure }
  \item{\code{"Z"}}{model matrix of subject i for covariance structure (the
  diagonal matrix)}
  \item{\code{"W"}}{model matrix of subject i for covariance structure (the
  lower triangular matrix)}
  \item{\code{"D"}}{the estimated diagonal matrix for subject i}
  \item{\code{"T"}}{the estimated lower triangular matrix for subject i}
  \item{\code{"Sigma"}}{the estimated covariance matrix for subject i}
  \item{\code{"mu"}}{the estimated mean for subject i}
  \item{\code{"pij"}}{a vector of remaining probability for subject i}
  \item{\code{"cpij"}}{a vector of cumulative remaining probability for subject i}
}}

\item{sub.num}{refer to i's subject}
}
\description{
Extract (or get) "components" - in a generalized sense - from a
  fitted joint mean covariance model from an object of class "geerMod".
}
\section{Methods (by class)}{
\itemize{
\item \code{geerMod}: Extract or Get Generalized Components from a Fitted
GEE-MCD/WGEE-MCD Model
}}

\examples{
fitgee.ar1 <- geer(cd4|id|time ~ 1|1, data = aids, triple =
  c(6,3,3), method = 'gee-mcd', corr.struct = 'ar1', rho = 0.5, control =
  geerControl(trace=TRUE))

sd  <- getGEER(fitgee.ar1, "sd")
QIC <- getGEER(fitgee.ar1, "QIC")
Di  <- getGEER(fitgee.ar1, "D", 10)

}
