% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{gecko.data}
\alias{gecko.data}
\title{Example data packaged with gecko}
\source{
This function is inspired by \code{\link[palmerpenguins:path_to_file]{palmerpanguins::path_to_file()}}
which in turn is based on \code{\link[readxl:readxl_example]{readxl::readxl_example()}}.
}
\usage{
gecko.data(data = NULL)
}
\arguments{
\item{data}{character. String of one of the data names mentioned in the description, e.g.: \code{"gecko.records"}.
If \code{NULL}, the example files will be listed.}
}
\description{
Load data included in the package. This includes \strong{records},
a matrix of longitude and latitude (two columns) occurrence records for
Hogna maderiana (Walckenaer, 1837); \strong{range}, a SpatRaster object, as
defined by package terra, of the geographic range of Hogna maderiana
(Walckenaer, 1837); \strong{layers}, a SpatRaster object with layers 
representing the average annual temperature, total annual precipitation,
altitude and landcover for Madeira Island
(Fick & Hijmans 2017, Tuanmu & Jetz 2014); \strong{threat}, a layer of mean 
fire occurence in Madeira between 2006 and 2016; and \strong{worldborders} is a
simplified version of the vector of world country borders created by
 \href{https://github.com/victorcazalis/RedList_countries}{Victor Cazalis}.
}
\examples{
\dontrun{
gecko.data()
gecko.data("range")
}
}
