% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs_geodetecor.R
\name{srs_interaction_detector}
\alias{srs_interaction_detector}
\title{spatial rough set-based interaction detector}
\usage{
srs_interaction_detector(y, x1, x2, wt)
}
\arguments{
\item{y}{Dependent variable, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{x1}{Covariate \eqn{X_1}, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{x2}{Covariate \eqn{X_2}, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{wt}{Spatial adjacency matrix.}
}
\value{
A list.
\describe{
\item{\code{Variable1 PD}}{the average local explanatory power for variable1}
\item{\code{Variable2 PD}}{the average local explanatory power for variable2}
\item{\code{Variable1 and Variable2 interact PD}}{the average local explanatory power for variable1 and variable2 interact}
\item{\code{Variable1 SE_PD}}{the degree of spatial heterogeneity of the local explanatory power for variable1}
\item{\code{Variable2 SE_PD}}{the degree of spatial heterogeneity of the local explanatory power for variable2}
\item{\code{Variable1 and Variable2 SE_PD}}{the degree of spatial heterogeneity of the local explanatory power for variable1 and variable2 interact}
\item{\code{Interaction}}{the interact result type}
}
}
\description{
spatial rough set-based interaction detector
}
\examples{
data('srs_table')
data('srs_wt')
srs_interaction_detector(srs_table$d,srs_table$a1,srs_table$a2,srs_wt)

}
\references{
Bai, H., Li, D., Ge, Y., Wang, J., & Cao, F. (2022). Spatial rough set-based
geographical detectors for nominal target variables. Information Sciences, 586, 525–539.
https://doi.org/10.1016/j.ins.2021.12.019
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
