`gcl` <-
function (df, nlev = 3, filter = 1.2, multi = NULL, gcl.verbose = T, 
    ...) 
{
    gcl.version <- "1.06.5"
    if (gcl.verbose) 
        cat("gcl", gcl.version, ": Creating Fuzzy Rules classifier with", 
            nlev, "fuzzy levels.\n")
    if (length(unlist(df)) == 0) 
        stop("gcl: Empty data, cannot build classifier. Bye.\n", 
            call. = F)
    if (is.factor(df[, ncol(df)])) 
        df[, ncol(df)] <- as.vector(df[, ncol(df)])
    fs <- "no filtering took place"
    fc <- class(filter)
    if (fc %in% c("matrix", "data.frame")) 
        fs <- "filtering data was supplied"
    else if (fc == "integer") {
        pc <- 100 * length(filter)/ncol(df)
        fs <- paste(pc, "% split off the training data")
        idx <- filter
        filter <- df[idx, , drop = F]
        df <- df[setdiff(1:nrow(df), idx), , drop = F]
    }
    else if (fc == "logical") {
        pc <- 100 * sum(filter)/ncol(df)
        fs <- paste(pc, "% split off the training data")
        idx <- filter
        filter <- df[idx, , drop = F]
        df <- df[!idx, , drop = F]
    }
    else if (fc == "numeric") {
        add.tdata <- F
        if (filter >= 1) {
            add.tdata <- T
            filter <- filter - floor(filter)
        }
        fi <- sample(1:nrow(df), ceiling(nrow(df) * filter))
        finc <- rep(F, nrow(df))
        finc[fi] <- T
        fs <- paste(100 * round(sum(finc)/nrow(df), 3), "% randomly split off the training data")
        if (add.tdata) 
            filter <- df
        else filter <- df[finc, , drop = F]
        df <- df[!finc, , drop = F]
    }
    else if (fc != "NULL") {
        filter <- NULL
        warning("Warning: filter of wrong class: ", fc, ". No filtering done.\n", 
            call. = F)
    }
    if (gcl.verbose) 
        cat(fs, "\n")
    if (!is.null(filter)) {
        if (dim(filter)[1] == 0) {
            warning("Too few elements for filtering. Turning off filtering.", 
                call. = F)
            filter <- NULL
        }
        if (dim(df)[1] == 0) 
            warning("Empty data.\n", call. = F)
    }
    if (gcl.verbose) 
        cat("gcl: generating rules...")
    r <- makerules(df, nlev, multi = multi, ...)
    if (gcl.verbose) 
        cat("gcl: done. Computed", length(r), "rules.\n")
    if (!is.null(filter) && gcl.verbose) 
        cat("gcl: filtering rules...")
    if (!is.null(filter) && !is.null(r)) 
        r <- filterrules(r, filter, ...)
    if (!is.null(filter) && gcl.verbose) 
        cat("gcl: done, kept", length(r), "rules.\n")
    ms <- paste("rule generation: ", if (is.null(multi)) 
        "no subsampling."
    else paste(multi, "-fold subsampling.", sep = ""), sep = "")
    ds <- paste("Generated by gcl v", gcl.version, " ", date(), 
        ".\n  nlev=", nlev, ", filtering: ", fs, "\n", "  ", 
        ms, "\n", mklicensestr(), "\n", sep = "")
    rlenave <- NULL
    if (!is.null(getOption("gcl.decorate"))) {
        ds <- paste(ds, paste(sapply(r, function(r) attr(r$f, 
            "gcl.ds")), collapse = "\n"), "\n", sep = "")
        rlens <- sapply(r, function(r) length(attr(r$f, "gcl.rant")))
        ratts <- sapply(r, function(r) attr(r$f, "gcl.rant"))
        rnatts <- length(unique(ratts))
        rlenave <- sum(rlens)/length(r)
    }
    f <- function(df = NULL, fun, rules, mkvm, ds) fun(df, rules, 
        mkvm, ds)
    cf <- makefun(f, list(fclassify, r, makevm, ds))
    environment(cf) <- globalenv()
    attr(cf, "summary.gcl.rnum") <- length(r)
    attr(cf, "summary.gcl.amean") <- rlenave
    attr(cf, "summary.gcl.natt") <- rnatts
    attr(cf, "summary.gcl.nlev") <- nlev
    return(cf)
}
